/***************************************************************************
 $RCSfile: customer.cpp,v $
                             -------------------
    cvs         : $Id: customer.cpp,v 1.6 2003/04/25 01:45:54 aquamaniac Exp $
    begin       : Sun Nov 18 2001
    copyright   : (C) 2001 by Martin Preuss
    email       : openhbci@aquamaniac.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef __declspec
# if BUILDING_DLL
#  define DLLIMPORT __declspec (dllexport)
# else /* Not BUILDING_DLL */
#  define DLLIMPORT __declspec (dllimport)
# endif /* Not BUILDING_DLL */
#else
# define DLLIMPORT
#endif

#include "assert.h"
#include "customer.h"

namespace HBCI {

Customer::Customer(Pointer<User> u,
                           const string &uid,
                           const string &custName)
    :_user(u)
    ,_custId(uid)
    ,_custName(custName)
{
}


Customer::Customer(const Customer &cu)
:_user(cu._user)
,_custId(cu._custId)
,_custName(cu._custName)
{
}


Customer::~Customer(){
}
/*
bool
Customer::operator==(const Customer &c) const
{
    return (c._custId == _custId) && 
	(c.user().ref() == _user.ref());
}
*/

} // namespace HBCI

const char* HBCI_Customer_custId(const HBCI_Customer *h)
{
    assert(h);
    return h->custId().c_str();
}


const char* HBCI_Customer_custName(const HBCI_Customer *h)
{
    assert(h);
    return h->custName().c_str();
}

void HBCI_Customer_setCustName(HBCI_Customer *h, const char *n)
{
    assert(h);
    h->setCustName(string(n ? n : ""));
    
}
const HBCI_User* HBCI_Customer_user(const HBCI_Customer *h)
{
    assert(h);
    return (h->user().ptr());
}



void list_HBCI_Customer_delete(list_HBCI_Customer *l)
{
    delete l;
}
void list_HBCI_Customer_iter_delete(list_HBCI_Customer_iter *l)
{
    delete l;
}
int list_HBCI_Customer_size(const list_HBCI_Customer *l)
{
    assert(l);
    return l->size();
}
list_HBCI_Customer_iter* list_HBCI_Customer_begin(const list_HBCI_Customer *l)
{
    assert(l);
    return new list_HBCI_Customer_iter(l->begin());
}
list_HBCI_Customer_iter* list_HBCI_Customer_end(const list_HBCI_Customer *l)
{
    assert(l);
    return new list_HBCI_Customer_iter(l->end());
}
const HBCI_Customer *
list_HBCI_Customer_iter_get(const list_HBCI_Customer_iter *l)
{
    assert(l);
    return (**l).ptr();
}
void
list_HBCI_Customer_iter_next(list_HBCI_Customer_iter *l)
{
    assert(l);
    l->operator++();
}
int list_HBCI_Customer_iter_equal(const list_HBCI_Customer_iter *l1, 
				 const list_HBCI_Customer_iter *l2)
{
    assert(l1);
    assert(l2);
    return (*l1) == (*l2);
}
void *list_HBCI_Customer_foreach (const list_HBCI_Customer *list, 
				  list_HBCI_Customer_cb func,
				  void *user_data)
{
    assert(list);
    assert(func);
    list_HBCI_Customer_iter iter, end;
    void *ret = 0l;

    end = list->end();
    for ( iter = list->begin(); iter != end; iter++ ) {
	ret = (*func)( (*iter).ptr(), user_data);
	if (ret)
	    break;
    }
    return ret;
}
