/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/


#include "pxmchem-fragopt.h"




PxmFragOpt *
pxmchem_fragopt_new (void)
{
  PxmFragOpt *fragopt = g_malloc0 (sizeof (PxmFragOpt));
  
  fragopt->mnm_chement = PXMCHEMENT_MNM_NONE;
  fragopt->plm_chement = PXMCHEMENT_PLM_NONE;
  fragopt->put_sequence = FALSE;
 
  return fragopt;
}
  

gboolean
pxmchem_fragopt_set_default (PxmFragOpt *fragopt)
{
  g_assert (fragopt != NULL);
  
  fragopt->mnm_chement = PXMCHEMENT_MNM_NONE;
  fragopt->plm_chement = PXMCHEMENT_PLM_NONE;
  fragopt->put_sequence = FALSE;
 
  return TRUE;
}


PxmFragOpt *
pxmchem_fragopt_dup (const PxmFragOpt *fragopt)
{
  PxmFragOpt *fragopt_new = g_malloc0 (sizeof (fragopt));
  
  g_assert (fragopt != NULL);
  g_assert (fragopt->fragspec != NULL);
  
  if (fragopt->fragspec != NULL)
    fragopt_new->fragspec = 
      pxmchem_fragspec_dup (fragopt->fragspec);

  fragopt_new->mnm_chement = fragopt->mnm_chement;
  fragopt_new->plm_chement = fragopt->plm_chement;
  fragopt_new->put_sequence = fragopt->put_sequence;

  return fragopt_new;
}


gboolean
pxmchem_fragopt_free  (PxmFragOpt *fragopt)
{
  g_assert (fragopt != NULL);
  
  if (fragopt->fragspec != NULL)
    pxmchem_fragspec_free (fragopt->fragspec);
  
  g_free (fragopt);

  return TRUE;
}


/* GPtrArray-RELATED FUNCTIONS
 */
gint
pxmchem_fragopt_GPA_free (GPtrArray *GPA)
{
  gint count = 0;
  
  PxmFragOpt *fragopt = NULL;
  
  
  g_assert (GPA != NULL);
  
  while (GPA->len > 0)
    {
      fragopt = g_ptr_array_remove_index (GPA, 0);
      g_assert (fragopt != NULL);
      pxmchem_fragopt_free (fragopt);
      count++;
    }
  
  g_ptr_array_free (GPA, TRUE);

  return count;
}
