#include <module.h>
inherit "module";
inherit "roxenlib";

//#define SWITCH_DEBUG

/*
 * Switch module for Roxen/1.2alpha and up.
 * If "switched on", it will reply all requests (with some exceptions)
 * the HTTP status code and text configured in it).
 * See the online documentation for more help
 *
 * (C) 1997 Francesco Chemolli <kinkie@comedia.it>
 * This code can be used, modified and redistributed freely under the terms
 * of the GNU General Public License version 2.
 * This code comes on a AS-IS basis, with NO WARRANTY OF ANY KIND, either
 * implicit or explicit. Use at your own risk.
 *
 */

#ifdef SWITCH_DEBUG
#define LOG(X) perror("Switchmodule: "+X+"\n");
#else
#define LOG(X) /**/
#endif

mapping first_try (object id) {
	if (!QUERY(switch)) { //okay, we gotta check.
		LOG("switch is off");
		return 0;
	}
	mixed tmp;
	foreach(QUERY(hosts_to_pass),tmp)
		if (glob(tmp,id->remoteaddr)) {
			LOG (sprintf ("Allowing: host %s matches glob %s",id->remoteaddr, tmp));
			return 0;
		}
	foreach(QUERY(docs_to_pass),tmp)
		if (glob(tmp,id->not_query)) {
			LOG (sprintf("Allowing: document %s matches glob %s",id->not_query,tmp));
			return 0;
		}
	LOG("switch triggered");
	return http_low_answer(QUERY(return_code),
			parse_rxml(QUERY(return_message),id)
			);
}

void create() {
	defvar ("switch",0,"Activate switch", TYPE_FLAG,
			"Should every server query get the default answer?"
			);
	defvar ("return_code",502,"Configuration: HTTP return code", 
			TYPE_MULTIPLE_INT,
			"What to return if <TT>server's switch</TT> is set (see Roxen's "
			"documentation for the values' meanings)<BR>"
			"The most useful are 200(OK), 30*(Moved), 403(Forbidden), "
			"404(No such resource), 500(Server error), 502(Service temporarily "
			"unavailible)",
			({ 200, 202, 300, 301, 302, 400, 401, 403, 404, 410, 500, 502 })
			);
	defvar ("return_message",
			"<title>Sorry, service is temporarily unavailible</title>"
			"\n<h2 align=center><configimage src=roxen.gif "
			"alt=\"Service unavailible\">\n"
			"<p><hr noshade>"
			"\n<i>Sorry</i></h2>\n"
			"<br clear>\n<font size=+2>This server is temporarily "
			"disabled for maintenance."
			"Please try again later.<p>\n</font>\n"
			"<hr noshade>"
			"<version>\n",
			"Configuration: Returned message",
			TYPE_TEXT_FIELD,
			"The explanatory message which should be sent along with the request."
			);
	defvar ("hosts_to_pass",({""}),"Configuration: IP addresses to allow "
			"anyways (globs)",
			TYPE_STRING_LIST,
			"The hosts which match any glob of these will be allowed access even if "
			"the switch is turned on."
			);
	defvar ("docs_to_pass", ({"/internal*"}),
			"Configuration: virtual files to allow anyways (globs)",
			TYPE_STRING_LIST,
			"The (virtual) documents which match any of these will be allowed access "
			"even if the switch is turned on."
			);
}

array register_module() {
	return ({
			MODULE_FIRST,
			"Switch",
			"This module can act as an "
			"ON-OFF switch for a virtual server, and thus the name.<BR>"
			"It can return "
			"an user-defined answer for every query the server receives,"
			"except queries from user-defined hosts or for user-defined docs.<BR>\n",
			0,
			0
			});
}

string cvs_version="$Id: switch.pike,v 1.2 1997/06/15 09:01:22 kinkie Exp $";
