#ifndef PACKAGE_NAMESPACE_STRING_H_INCLUDED
#define PACKAGE_NAMESPACE_STRING_H_INCLUDED 1

#include <string>
#include <map>
namespace PACKAGE_NAMESPACE {

        /**
           Convenience typedef for use with translate_entities() and xml_entity_map().
         */
        typedef std::map<std::string,std::string> EntityMap;

        /**
           For each entry in the input string, the characters are
           mapped to string sequences using the given
           translation_map. Where no mappings exist, the input
           characters are left as-is.

           It returns the number of translations made.

           If reverse_translation == true then a reverse mapping is
           done: map values are treated as keys. 

           This is useful, for example, for doing XML-entity-to-char
           conversions.

           It is amazingly INefficient, but seems to work okay.

        */
        unsigned long translate_entities( std::string &, const EntityMap & translation_map, bool reverse_translation = false );


        /**
           A policy enum used by trim_string().
        */
        enum TrimPolicy {
        /**
           Trim only leading spaces.
         */
        TrimLeading = 0x01,
        /**
           Trim only trailing spaces.
         */
        TrimTrailing = 0x02,
        /**
           Trim leading and trailing spaces.
         */
        TrimAll = TrimLeading + TrimTrailing
        };

        /**
           Trims leading and trailing whitespace from the input string
           and returns the number of whitespace characters removed.
         */
        unsigned int trim_string( std::string &, TrimPolicy = TrimAll );
        /**
           Trims leading and trailing whitespace from the input string
           and returns the trimmed string.
         */
        std::string trim_string( const std::string &, TrimPolicy = TrimAll );


        /**
           Attempts to remove all backslash-escaped chars from str.

           Removes backslash-escaped newlines from the input string, including
           any whitespace immediately following each backslash.

           The optional slash parameter defines the escape character.
        */
        unsigned long strip_slashes( std::string &str, const char slash = '\\' );

        /**
           Adds an escape sequence in front of any characters in
           instring which are also in the list of chars_to_escape.
           Returns the number of escapes added.

           e.g., to escape (with a single backslash) all $, % and \ in
           mystring with a backslash:

           <pre>
           escape_string( mystring, "$%\\", "\\" );
           </pre>

           (WARNING: the doxygen-generated HTML version of these docs
           may incorrectly show single backslashes in the above example!)


        */
        unsigned long escape_string( std::string & instring, const std::string & chars_to_escape, const std::string & escape_seq = "\\" );

        /**
           normalize_string() is like trim_string() and
           strip_slashes(), combined, plus it removes leading/trailing
           quotes:

           <pre>
           "this is a \
           sample multi-line, backslash-escaped \
           string."
           </pre>
           
           Will translate to:
           <pre>
           this is a sample multi-line, backslash-escaped string.
           </pre>
        */
        void normalize_string( std::string & );


        /**
           Returns the first whitespace-delimited token from the given
           string.
        */
        std::string first_token( const std::string & );

        /**
           Returns the passed-in string, minus the first token.
         */
        std::string after_first_token( const std::string & );



        /**
           Returns int values for chars '0'-'9', 'a'-'f' and 'A'-'F',
           else -1.
        */
        unsigned int int4hexchar( char c );

        /**
           Assumes wd to be a hex-encoded number. Returns it's decimal
           value. It may optionally be prefixed with '#', as in
           \#ff00ff. Case is insignificant.
        */
        int hex2int( const std::string & wd );



} // namespace PACKAGE_NAMESPACE

#endif // PACKAGE_NAMESPACE_STRING_H_INCLUDED
