'\" 
'\" Copyright (c) 1995-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" RCS: @(#) $Id: fconfigure.n,v 1.2 2003/11/24 05:09:59 bbbush Exp $
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: fconfigure.n,v 1.2 2003/11/24 05:09:59 bbbush Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH fconfigure n 8.1 Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
fconfigure \- 设置和获得一个通道上的选项      
.SH "总览 SYNOPSIS"
.nf
\fBfconfigure \fIchannelId\fR
\fBfconfigure \fIchannelId\fR \fIname\fR
\fBfconfigure \fIchannelId\fR \fIname value \fR?\fIname value ...\fR?
.fi
.BE

.SH "描述 DESCRIPTION"
.PP
\fBfconfigure\fR   命令设置和检索一个通道的选项。\fIChannelId\fR 标识要设置或查询某个选项的那个通道。如果没有提供 \fIname\fR 或 \fIvalue\fR 参数，命令返回一个列表，它包含着这个通道上可变更的选项名字和值。如果提供了 \fIname\fR 而没有 \fIvalue\fR  则命令返回给定选项的当前值。如果提供一对或多对 \fIname\fR和 \fIvalue\fR，命令把每个指名的选项设置成相应的 \fIvalue \fR；在这种情况下返回值是一个空串。
.PP
所有通道都支持下面描述的选项。额外的，每个通道类型都可以增加只有它自己支持的选项。参见建立各种类型通道的命令的手册条目来得到这个特定类型的通道所支持的选项。例如，参见  \fBsocket\fR命令的手册条目来得到增补的选项。
.TP
\fB\-blocking\fR \fIboolean\fR
\fB-blocking\fR  选项决定在通道上的 I/O  操作是否可以导致进程无限的阻塞。选项的值必须是一个正确的 boolean  值。通道通常在阻塞模式中；如果把一个通道转换到非阻塞模式中，它将影响 \fBgets\fR、\fBread\fR、\fBputs\fR、\fBflush\fR、和 \fBclose\fR  命令的操作；详见这些命令的文档。要使非阻塞模式正常工作，应用必须使用 Tcl    事件循环(例如，通过调用 \fBTcl_DoOneEvent\fR  或调用 \fBvwait\fR  命令)。 
.TP
\fB\-buffering\fR \fInewValue\fR
.
如果 \fInewValue\fR  是 \fBfull\fR，则 I/O 系统直到它的内部缓冲变满或调用 \fBflush\fR   命令之后才将缓冲输出。如果 \fInewValue\fR 是 \fBline\fR，则 I/O 系统将在输出一个换行符的时候自动的刷新此通道的输出。如果 \fInewValue\fR  是 \fBnone\fR，则 I/O 系统将在每次输出操作之后自动刷新。除了连接到终端类设备的通道被初始设置成 \fBline \fR之外，\fB-buffering\fR  的缺省被设置成 \fBfull\fR。补充一下，\fBstdin\fR  和 \fBstdout\fR  被初始设置成 \fBline\fR，而 \fBstderr\fR 被设置成 \fBnone\fR。               
.TP
\fB\-buffersize\fR \fInewSize\fR
.
\fINewvalue\fR必须是一个整数；使用它的值来设置随后分配给这个通道用来存储输入和输出的缓冲区的大小，以字节为单位。\fINewvalue\fR  必须在十到一百万之间，即允许十到一百万字节大小的缓冲区。 
.VS 8.1 br
.TP
\fB\-encoding\fR \fIname\fR
.
用这个选项来指定通道的编码，为了在 Tcl 中使用数据，数据可以转换成 Unicode 或从 Unicode 转换过来。例如，要使 Tcl 从用 \fBshiftjis\fR  编码的日文文件中读取字符并正确的处理和显示其中的内容，编码就应该设置成 \fBshiftjis\fR。此后，当从一个通道读取的时候，在这个日文文件中的字节如其所读的将被转换成 Unicode。同样也支持写入 - 即把要写到通道中的 Tcl 字符串自动的转换成输出上的特定编码。
.RS
.PP
如果一个文件包含纯二进制数据(例如，一个 JPEG 图象)，这种通道应当被配置成 \fBbinary\fR。Tcl  将对这种文件中的数据不赋予任何解释，而是简单的读或写原始(raw)的字节。使用Tcl \fBbinary\fR  命令操纵这种原始字节数据。
.PP
给新打开的通道的缺省编码与同操作系统交互时使用的依赖于平台或本地的编码是一样的。              
.RE
.VE
.TP
\fB\-eofchar\fR \fIchar\fR
.TP
\fB\-eofchar\fR \fB{\fIinChar outChar\fB}\fR
.
这个选项支持 DOS 文件系统，它使用 Control-z (\ex1a)作为文件结束的标记符(marker)。如果 \fIchar\fR  不是一个空串，则在输入期间遇到这个字符时指示(signal)文件结束。对于输出，在关闭通道的时候输出文件结束字符。如果 \fIchar\fR 是一个空串，则没有特定的文件结束字符标记符。对于读写通道，一个有两个元素的列表分别指定给输入和输出的文件结束标记符。作为一种约定，在给读写通道设置文件结束符的时候，你可以指定一个单一的值，同时提供给读和写。在查询一个读写通道的文件结束符时，将返回一个两个元素的列表。除了在 Windows 下的文件之外的情况下，\fB-eofchar\fR  缺省值是一个空串。在Windows 的情况下，对于读 \fB-eofchar\fR  是 Control-z (\ex1a)，对于写是空串。              
.TP
\fB\-translation\fR \fImode\fR
.TP
\fB\-translation\fR \fB{\fIinMode outMode\fB}\fR 
.
在 Tcl 脚本中总是使用一个单一的换行符(\en)来表示一行的结束。但是在实际的文件和设备中的行结束在不同的平台上可能有不同的表示，甚至在相同的平台的不同的设备上也可能有不同的表示。例如，在 UNIX 下在文件中是换行符，而在网络连接中通常使用回车-换行(carriage-return-linefeed)序列。在输入上  (例如，使用 \fBgets\fR 和 \fBread\fR)，Tcl I/O 系统自动的把外部的行结束表示转换成换行符。在输出上(例如，使用 \fBputs\fR)，I/O 系统把换行符转换成外部的行结束表示。缺省的转换模式是 \fBauto\fR，即自动的处理所有一般情况，而 \fB-translation\fR 
 选项在提供显式的对行结束转换的控制。
.PP
对于只读和只写通道，与 \fB-translation\fR   相关联的值是一个单一的项目。对于读写通道这个值是一个两个元素的列表；列表的第一个元素是读转换模式，第二个元素是写转换模式。作为一种约定，在给读写通道设置行结束符的时候，你可以指定一个单一的值，同时提供给读和写。在查询一个读写通道的行结束符时，将返回一个两个元素的列表。当前支持下列值:              
.TP
\fBauto\fR
.
作为输入转换模式，\fBauto\fR  把所有的换行(\fBlf\fR)、回车(\fBcr\fR)、或一个回车并跟随一个换行(\fBcrlf\fR) 作为行结束表示。行结束表示甚至可以从行到行的改变，并且所有的情况都被转换成一个换行符。作为输出转换模式，\fBauto\fR  选择一个特定于平台的表示；对于套接口，Tcl 在所有平台上均选择 \fBcrlf\fR，对于所有 Unix 版本(flavor)，它选择 \fBlf\fR，对Macintosh 平台它选择 \fBcr\fR，对于各种版本的Windows 它选择 \fBcrlf\fR。对于输入和输出二者，\fB-translation\fR的缺省设置是 \fBauto\fR。               
.VS 8.1 br
.TP
\fBbinary\fR 
.
不进行行结束转换。除了 \fBbinary\fR模式额外的把文件结束符设置成空串(禁用文件结束符)，并且把编码设置成 \fBbinary\fR (禁用编码过滤)之外，它与\fBlf\fR  模式基本一致。详细信息参见 \fB-eofchar\fR 和 \fB-encoding\fR。               
.VE
.TP
\fBcr\fR
.
在底层文件或设备中的行结束被表示为一个单一的回车符。作为输入转换模式，\fBcr\fR模式把回车符转换成换行符。作为输出转换模式，\fBcr\fR模式把换行符转换成回车符。这种模式典型的在 Macintosh 平台上使用。               
.TP
\fBcrlf\fR
.
在底层文件或设备中的行结束被表示一个回车符并跟随一个换行符。作为输入转换模式，\fBcrlf\fR模式把回车换行序列转换成换行符。作为输出模式，\fBcrlf\fR 模式把换行符转换成回车换行序列。这种模式典型的在 Windows  平台和网络连接上使用。 
.TP
\fBlf\fR
.
在底层文件或设备中的行结束被表示为一个单一的换行符。在这种模式下在输入或输出期间没有转换发生。这种模式典型的在UNIX 平台上使用。
.RE
.PP

.SH "参见 SEE ALSO"
close(n), flush(n), gets(n), puts(n), read(n), socket(n)

.SH "关键字 KEYWORDS"
blocking, buffering, carriage return, end of line, flushing, linemode,
newline, nonblocking, platform, translation, encoding, filter, byte array,
binary

.SH "[中文版维护人]"
.B 寒蝉退士
.SH "[中文版最新更新]"
.B 2001/08/02
.SH "《中国 Linux 论坛 man 手册页翻译计划》:"
.BI http://cmpp.linuxforum.net
