/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

#ifndef _NET_INTERNAL_H
#define _NET_INTERNAL_H

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/file.h>
#include <memory.h>
#include <errno.h>
#include <unistd.h>
#include <fcntl.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/un.h>
#include <signal.h>
#include "mas/mas_dpi.h"
#include "mas/rtp_api.h"
#include "mas/mas_nanosleep_reality.h"
#include "auth_host.h"

#define RTP_TCP_LISTEN_PORT    6200
#define RTCP_TCP_LISTEN_PORT   6201
#define XCM_LISTEN_WINDOWID    "Media Application Server 0"

#define MAX_PACKET_SIZE      2048
#define HOSTNAME_LEN          256
#define DYNPORT_POOL_SIZE       8

#define MAS_SUCCESS        0
#define MAS_MEMLMT_RCHD   -1
#define MAS_NETHN_NPMIT   -2
#define MAS_NETHN_NFND    -3
#define MAS_NETADR_NPMIT  -4
#define MAS_OPARG_IVLD    -5

enum net_listen_state
{
    NOT_LISTENING = 0,
    LISTENING = 1,
    SETUP = 2,
    STRIKE = 3
};

enum net_peer_state
{
    DOWN = 0,
    AUTH1 = 1,
    UP = 2
};

/************************************************************************
 * net_rtp_peer_node
 *
 * Linked-list node handle for an RTP peer.  Used by this device to
 * maintain a linked list of active peers.  A client or another MAS
 * server connects again to this device, she is allocated another
 * net_rtp_peer_node struct.  Thus, there is the potential for many
 * active channels, or sessions of communication between two
 * processes.  For example, this allows for some data to be sent over
 * a lossy channel, while control information is always lossless.
 *
 ************************************************************************/
struct net_rtp_peer_node
{
    int32      id;
    int        session_type; /* one of RTP_SESSTYPE_* */
    enum net_peer_state state;

    /* RTP_SESSTYPE_* defined in jrtplib C wrapper */
    int        data_in_rtp_socket;
    int        data_in_rtcp_socket;
    int        data_in_library;
    int        send_blocked;

    char *version;
    struct mas_package infopack;
    
    /* the SSRC id of the peer */
    uint32     ssrc;

    /* the SSRC id of the peer's control channel */
    int32 control_ssrc;

    /* this channel type */
    int32      type;

    /* the local mas ports */
    int32      sink;
    int32      source;
    int32      response;

    /* used by the rtp_api wrapper for jrtplib */
    struct rtp_session*  session;

    /* holds peer address info. */
    struct sockaddr*     peer_addr;

    struct net_rtp_peer_node* prev;
    struct net_rtp_peer_node* next;
};

/************************************************************************
 * net_rtp_state
 *
 * State memory structure for this device instance.
 *
 ************************************************************************/
struct net_rtp_state
{
    int32 device_instance;
    
    struct net_rtp_peer_node* peer_list_head;
    int32                next_peer_id;

    fd_set               fd_set_all_auth_sockets;
    int                  max_auth_fd;
    fd_set               fd_set_all_listen_sockets;
    int                  max_listen_fd;

    MAS_SOCKET           rtp_listen_tcp;
    MAS_SOCKET           rtcp_listen_tcp;
    MAS_SOCKET           rtp_listen_unix;
    MAS_SOCKET           rtcp_listen_unix;
    
    enum net_listen_state tcp_listen_state;
    enum net_listen_state unix_listen_state;
    int polling_scheduled;
    int has_signals;
    
    struct masd_dynport_pool dp_pool;
    
    uint32 ssrc; /* the local SSRC, used for all sessions */
    char  hostname[HOSTNAME_LEN];
    char  short_hostname[HOSTNAME_LEN];

    struct host_list hl;
    
    /* ports */
    int32 reaction;

    char version[64];
};

#endif /* _NET_INTERNAL_H */
