//
// Start up a simulation of a single axon.
//
z_length = 5000;
n_z = 400;
z_spacing = z_length/n_z;
z_grid = (0:z_length/n_z:z_length*(1-1/n_z)) + z_length/(2*n_z);


s_ax = SingleAxon_new(z_grid, 1, 0.8, 70);	// Calls constructor, and
						// returns a pointer
						// which must be supplied
						// on all member accesses.
	

SingleAxon_set_g_syn(s_ax, 0.005);
				// Accesses a public data member.

SingleAxon_initialize(s_ax, -65); // Call a member function.

for (j = 1; j <= 25; j++) {
  for (i = 1; i <= 10; i++) {
    SingleAxon_save_voltages(s_ax); // Save voltages so we can compute dV/dt.
    SingleAxon_advance(s_ax, 0.05, zeros(length(z_grid)));
				// Advance to the next timestep, supplying an
				// extracellular potential which is 0
				// everywhere.
  };
  plot(z_grid, SingleAxon_get_vm(s_ax),	// Display voltages and currents.
       z_grid, 200*SingleAxon_Im_compartment(s_ax));
  resp = input_string("Press return to continue: ");
};

SingleAxon_delete(s_ax);	// Call the destructor and free the memory.
