# --------------------------------------------------------------------------
# contents: Dependencies of files in component 'SAPDB/SAPDBCommon/Algorithms/'.
# to do:    Reduce the dependencies by using forward declarations!
# author:   Mirko.Luedde@SAP.Com
# created:  Wed Jan  5 17:04:41  2000
# updated:  Mon Feb 28 16:22:18  2000
# --------------------------------------------------------------------------
#
#
#    ========== licence begin  GPL
#    Copyright (c) 2000-2004 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end
#

#


# Compile options for all files
* -except -DUSE_SAPDB_TYPE inc=:SAPDB/SAPDBCommon/SAPDB_Types.hpp

# Compile options for selected files. 
# Extends the include path for the compiler. 
# regex(.*\.cpp$) -I$WRK/incl/SAPDB/SAPDBCommon/Memory_Management -I$WRK/incl/SAPDB/SAPDBCommon/Algorithms -I$WRK/incl/STL

SAPDBAlgo_Comparator.hpp      inc=

SAPDBAlgo_QuickSort.hpp       inc=SAPDB_Types.hpp,\
                                  SAPDBAlgo_Comparator.hpp,\
                                  SAPDBErr_Assertions.hpp


SAPDBAlgo_FNVHash.hpp         inc=SAPDB_Types.hpp

SAPDBAlgo_FunnelMerge.hpp     inc=SAPDB_Types.hpp,\
                                  SAPDBAlgo_Comparator.hpp,\
                                  SAPDBAlgo_Exceptions.hpp,\
                                  SAPDBAlgo_Messages.hpp,\
                                  SAPDBErr_Assertions.hpp,\
                                  SAPDBErr_MessageList.hpp,\
                                  SAPDBMem_IRawAllocator.hpp,\
                                  SAPDBMem_NewDestroy.hpp

SAPDBAlgo_MD5File.h	      inc=-SAPDB_Types.hpp
SAPDBAlgo_MD5File.c           inc=-SAPDB_Types.hpp,+RTESys_IO.h

SAPDBAlgo_Messages.hpp        inc=SAPDBErr_MessageList.hpp

SAPDBAlgo_Exceptions.hpp      inc=SAPDBAlgo_Messages.hpp,\
                                  SAPDBErr_MessageList.hpp

SAPDBAlgo_Test.hpp            inc=ggg00,gsp00
SAPDBAlgo_Test.cpp            inc=SAPDB_Types.hpp,\
                                  SAPDBAlgo_Test.hpp,\
                                  SAPDBAlgo_Comparator.hpp,\
                                  SAPDBAlgo_FunnelMerge.hpp,\
                                  SAPDBAlgo_QuickSort.hpp,\
                                  SAPDBAlgo_Messages.hpp,\
                                  SAPDBAlgo_Exceptions.hpp,\
                                  SAPDBErr_Assertions.hpp,\
                                  SAPDBMem_IRawAllocator.hpp,\
                                  RTE_Message.hpp,\
                                  ggg00,gsp00,ggg200.h
                                  

&if $OSSPEC == LINUX && $MACH in [ S390X, IA64 ]
regex(\w+\.cpp) -OPT=-O2
&endif

