/*!
  @file           Container_SortableVector.hpp
  @author         HenrikH, ContainerMaint
  @brief          Class declaration and definition for a template vector class
  @see            
  @author         HenrikH

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2002-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


\endif
*/


#ifndef CONTAINER_SORTABLEVECTOR_HPP
#define CONTAINER_SORTABLEVECTOR_HPP

#include "SAPDBCommon/Algorithms/SAPDBAlgo_QuickSort.hpp"  // QuickSort
#include "Container/Container_Vector.hpp"


/*!
  @class          Container_SortableVector
   @brief          This class implements a sortable vector class.


                Simple subclass of Container_Vector

 */



template <class T>
class Container_SortableVector : public Container_Vector<T>
{

public:
    // typedef copied from Container_Vector.hpp to please various C++ compilers
    typedef SAPDBMem_IRawAllocator Allocator; // Allocator type used for vectors

    /*!
       @brief          Constructs a vector
       @param          RawAlloc [in] The raw allocator providing the vector with memory.


                    A vector can only be constructed, if a raw allocator is given.
                    Thus, a default constructor is not offered.

     */

    Container_SortableVector(Allocator& RawAlloc);

    /*!
       @brief          sorts the vector

     */

    SAPDB_Bool QuickSort();
};

 

template <class T>
Container_SortableVector<T>::Container_SortableVector(Allocator& RawAlloc)
        : Container_Vector<T>(RawAlloc)
{ }

template <class T>
SAPDB_Bool Container_SortableVector<T>::QuickSort()
{
    return SAPDBAlgo_QuickSort(this->m_ArrayPtr, this->m_Size);
}

// -----------------------------------------------------------------------------

// -----------------------------------------------------------------------------

#endif // CONTAINER_SORTABLEVECTOR_HPP
