/*
-------------------------------------------------------------------- 
                  The PHP License, version 3.0
Copyright (c) 1999 - 2005 The PHP Group. All rights reserved.
-------------------------------------------------------------------- 

Redistribution and use in source and binary forms, with or without
modification, is permitted provided that the following conditions
are met:

  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
 
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in
     the documentation and/or other materials provided with the
     distribution.
 
  3. The name "PHP" must not be used to endorse or promote products
     derived from this software without prior written permission. For
     written permission, please contact group@php.net.
  
  4. Products derived from this software may not be called "PHP", nor
     may "PHP" appear in their name, without prior written permission
     from group@php.net.  You may indicate that your software works in
     conjunction with PHP by saying "Foo for PHP" instead of calling
     it "PHP Foo" or "phpfoo"
 
  5. The PHP Group may publish revised and/or new versions of the
     license from time to time. Each version will be given a
     distinguishing version number.
     Once covered code has been published under a particular version
     of the license, you may always continue to use it under the terms
     of that version. You may also choose to use such covered code
     under the terms of any subsequent version of the license
     published by the PHP Group. No one other than the PHP Group has
     the right to modify the terms applicable to covered code created
     under this License.

  6. Redistributions of any form whatsoever must retain the following
     acknowledgment:
     "This product includes PHP, freely available from
     <http://www.php.net/>".

THIS SOFTWARE IS PROVIDED BY THE PHP DEVELOPMENT TEAM ``AS IS'' AND 
ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE PHP
DEVELOPMENT TEAM OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

-------------------------------------------------------------------- 

This software consists of voluntary contributions made by many
individuals on behalf of the PHP Group.

The PHP Group can be contacted via Email at group@php.net.

For more information on the PHP Group and the PHP project, 
please see <http://www.php.net>.

This product includes the Zend Engine, freely available at
<http://www.zend.com>.
*/

/*!
@file           php_maxdb.h
@author         Thomas Simenec (thomas.simenec@sap.com)
@ingroup        PHP MaxDB
@brief          PHP MaxDB - PHP driver for the MaxDB database
@see            
*/

#ifndef PHP_MAXDB_H
#define PHP_MAXDB_H

extern zend_module_entry maxdb_module_entry;
#define phpext_maxdb_ptr &maxdb_module_entry

#ifdef PHP_WIN32
#define PHP_MAXDB_API __declspec(dllexport)
#else
#define PHP_MAXDB_API
#endif

#ifdef ZTS
#include "TSRM.h"
#endif

#include <limits.h>
#include <stdlib.h>
#include "SQLDBC_C.h"

#if ZEND_MODULE_API_NO >= 20040412
#define MAXDB_OO 1
#endif

typedef struct maxdb_connection *maxdb_connectionp;

/*
 * internal structure for holding column of a result set
 */
typedef struct maxdb_result_value {
	char           *buf;                         /* pointer to internal buffer */
	char            bufName[64];                 /* name of the buffer */
    SQLDBC_Length   bufLen;                      /* maximum length of buffer within the result */
    SQLDBC_HostType hostType;                    /* column datatyp */
    SQLDBC_Length   indicator;                   /* column indicator */
    SQLDBC_Bool     chopBlanks;                  /* flag if blanks chopped from string */
	SQLDBC_Bool     isint;                       /* flag if value is int bound as ASCII */
} maxdb_result_value;

/*
 * internal structure for holding a result set
 */
typedef struct maxdb_result {
	SQLDBC_Int4               m_id;              /* resource identifier */
	SQLDBC_ResultSet         *m_resultset;       /* SQLDBC result set */
	SQLDBC_ResultSetMetaData *m_rsmd;            /* result set metadata */
	maxdb_result_value       *m_cols;            /* columns of the result set */
	SQLDBC_UInt4              m_numcols;         /* number of columns in result set */
	SQLDBC_Bool               m_rowNotFound;     /* flag if rows found or not */
	SQLDBC_Int4               m_rowsaffected;	 /* rows affected in the last database query */
	SQLDBC_UInt4              m_rowSetSize;      /* size of the used rowset */
	SQLDBC_Int4               m_lastindex;       /* last column index (for maxdb_fetch_field()) */
	zval                    **m_vars;            /* PHP vars bound to result set */
	SQLDBC_UInt4              m_varscnt;         /* number of PHP vars bound to result set */
	SQLDBC_Bool               m_noclose;         /* flag if result set should be closed or not */
	SQLDBC_Int4               m_connid;          /* resource identifier for connection */
    maxdb_connectionp         m_conn;            /* connection for result set */
} maxdb_result;

/*
 * internal structure for holding a statement parameter
 */
typedef struct maxdb_bind_param {
    char           *buf;                         /* pointer to internal buffer */
	char           *lob;                         /* buffer holding temporary lob data */
	SQLDBC_Int4     paramlen;                    /* length of the bound parameter */
	int             sqltype;                     /* internal sqltype of the bound parameter */
	SQLDBC_HostType hostType;                    /* hosttype of the bound parameter */
	SQLDBC_Length   indicator;                   /* indicator of the bound parameter */
	zval           *var;                         /* PHP var of the parameter */
	SQLDBC_Bool     isint;                       /* flag if value is int bound as ASCII */
} maxdb_bind_param;

/*
 * internal structure for holding a prepared statement
 */
typedef struct maxdb_prepstmt {
	SQLDBC_Int4               m_id;              /* resource identifier */
	SQLDBC_PreparedStatement *m_prepstmt;        /* SQLDBC prepared statement */
    maxdb_bind_param         *m_bindparams;      /* prepared statement parameters */
	SQLDBC_Int2               m_parcnt;          /* number of prepared statement parameters */
	SQLDBC_ParameterMetaData *m_parammetadata;   /* parameter metadata */
	SQLDBC_Bool               m_rownotfound;     /* flag if row not found or not */
	maxdb_result             *m_result;          /* result set for prepared statement (if query) */
	SQLDBC_Bool               m_isexecuted;      /* flag if statement was already executed or not */
	zval                     *m_clink;           /* link to connection */
} maxdb_prepstmt;

/*
 * internal structure for holding connection
 */
typedef struct maxdb_connection {
	char                     *m_host;            /* hostname used for connect */
	char                     *m_db;              /* database name used for connect */
    char                     *m_user;            /* user name used for connect */
    char                     *m_passwd;          /* password used for connect */
	SQLDBC_ConnectProperties *m_connprop;        /* connect properties for connect */
	SQLDBC_Connection        *m_connection;      /* SQLDBC connection */
	SQLDBC_ErrorHndl         *m_errhndl;         /* error handle for connect errors */
	SQLDBC_Statement         *m_stmt;            /* statement for maxdb_query() */
	SQLDBC_PreparedStatement *m_prepstmt;        /* statement for prepare */
	SQLDBC_Bool               m_isprepared;      /* flag if m_prepstmt was prepared or not */
	SQLDBC_Int4               m_rowsaffected;    /* rows affected in last database query */
	SQLDBC_Int4               m_numcols;         /* number of result columns (for maxdb_field_count()) */
	SQLDBC_Int4               m_id;              /* resource identifier */
	SQLDBC_Int4               m_resultid;        /* resource identifier for resultset of m_stmt */
    maxdb_result             *m_result;          /* result set for connection */
} maxdb_connection;

#if ZEND_MODULE_API_NO >= 20040412

static
	ZEND_BEGIN_ARG_INFO(second_arg_force_by_ref_rest, 1)
		ZEND_ARG_PASS_INFO(0)
	ZEND_END_ARG_INFO();

static
    ZEND_BEGIN_ARG_INFO(third_arg_force_by_ref_rest, 1)
		ZEND_ARG_PASS_INFO(0)
		ZEND_ARG_PASS_INFO(0)
	ZEND_END_ARG_INFO();

#ifdef MAXDB_OO
static
	ZEND_BEGIN_ARG_INFO(all_args_force_by_ref, 1)
	ZEND_END_ARG_INFO();
#endif
#else
static unsigned char second_arg_force_by_ref_rest[] = { 2, BYREF_NONE, BYREF_FORCE_REST };
static unsigned char third_arg_force_by_ref_rest[] = { 3, BYREF_NONE, BYREF_NONE, BYREF_FORCE_REST };
#endif

#ifdef MAXDB_OO
#define PHP_MAXDB_EXPORT(__type) PHP_MAXDB_API __type

static zend_object_handlers maxdb_object_handlers;
static HashTable classes;
static HashTable maxdb_link_properties;
static HashTable maxdb_result_properties;
static HashTable maxdb_stmt_properties;

typedef struct {
	void		*ptr;		/* resource: (maxdb, result, stmt)   */
	void		*info;		/* additional buffer				 */
} MAXDB_RESOURCE;

typedef struct _maxdb_object {
	zend_object 	zo;
	void 			*ptr;
	char			valid;
	HashTable 		*prop_handler;
} maxdb_object; /* extends zend_object */

zend_class_entry *maxdb_link_class_entry;
zend_class_entry *maxdb_stmt_class_entry;
zend_class_entry *maxdb_result_class_entry;

zend_class_entry _maxdb_link_class_entry;
zend_class_entry _maxdb_stmt_class_entry;
zend_class_entry _maxdb_result_class_entry;

PHP_MAXDB_EXPORT(zend_object_value) maxdb_objects_new(zend_class_entry * TSRMLS_DC);
#endif

#ifdef MAXDB_OO
#define REGISTER_MAXDB_CLASS_ENTRY(name, maxdb_entry, class_functions) { \
	INIT_CLASS_ENTRY(_##maxdb_entry,name,class_functions); \
	_##maxdb_entry.create_object = maxdb_objects_new; \
	maxdb_entry = zend_register_internal_class(&_##maxdb_entry TSRMLS_CC); \
}

#define MAXDB_REGISTER_RESOURCE_EX(__ptr, __zval, __ce)  \
	((maxdb_object *) zend_object_store_get_object(__zval TSRMLS_CC))->ptr = __ptr; \
	((maxdb_object *) zend_object_store_get_object(__zval TSRMLS_CC))->valid = 1;

#define MAXDB_REGISTER_RESOURCE(__ptr, __ce) \
{\
	zval *object = getThis();\
	if (!object) {\
		object = return_value;\
		Z_TYPE_P(object) = IS_OBJECT;\
		(object)->value.obj = maxdb_objects_new(__ce TSRMLS_CC);\
	}\
	MAXDB_REGISTER_RESOURCE_EX(__ptr, object, __ce)\
}

#define MAXDB_RETURN_RESOURCE(__ptr, __ce) \
	Z_TYPE_P(return_value) = IS_OBJECT; \
	(return_value)->value.obj = maxdb_objects_new(__ce TSRMLS_CC); \
	MAXDB_REGISTER_RESOURCE_EX(__ptr, return_value, __ce)

#define MAXDB_FETCH_RESOURCE(__ptr, __type, __id, __name) \
{ \
	MAXDB_RESOURCE *my_res; \
	maxdb_object *intern = (maxdb_object *)zend_object_store_get_object(*(__id) TSRMLS_CC);\
	if (!(my_res = (MAXDB_RESOURCE *)intern->ptr)) {\
  		php_error(E_WARNING, "Couldn't fetch %s", intern->zo.ce->name);\
  		RETURN_NULL();\
  	}\
	if (!intern->valid) { \
		php_error(E_WARNING, "invalid resource %s", intern->zo.ce->name); \
		RETURN_NULL(); \
	} \
	__ptr = (__type)my_res->ptr; \
	if (!strcmp((char *)__name, "maxdb_stmt")) {\
		if (!((maxdb_prepstmt *)__ptr)->m_prepstmt) {                   \
  			php_error(E_WARNING, "Statement isn't valid anymore");\
			RETURN_NULL();\
        }                 \
	}\
}

#define MAXDB_CLEAR_RESOURCE(__id) \
{ \
	maxdb_object *intern = (maxdb_object *)zend_object_store_get_object(*(__id) TSRMLS_CC);\
	efree(intern->ptr); \
	intern->ptr = NULL; \
}

#define MAXDB_ADD_PROPERTIES(a,b) \
{ \
	int i = 0; \
	while (b[i].pname != NULL) { \
		maxdb_add_property(a, b[i].pname, (maxdb_read_t)b[i].r_func, NULL TSRMLS_CC); \
		i++; \
	}\
}
#endif

#define MAXDB_REPORT_OFF      0  /* no error reporting */
#define MAXDB_REPORT_ERROR    2  /* error reporting on */

PHP_MINIT_FUNCTION(maxdb);
PHP_MSHUTDOWN_FUNCTION(maxdb);
PHP_RINIT_FUNCTION(maxdb);
PHP_RSHUTDOWN_FUNCTION(maxdb);
PHP_MINFO_FUNCTION(maxdb);

PHP_FUNCTION(maxdb_debug);
PHP_FUNCTION(maxdb_enable_reads_from_master);
PHP_FUNCTION(maxdb_disable_reads_from_master);
PHP_FUNCTION(maxdb_enable_rpl_parse);
PHP_FUNCTION(maxdb_disable_rpl_parse);
PHP_FUNCTION(maxdb_rpl_parse_enabled);
PHP_FUNCTION(maxdb_rpl_probe);
PHP_FUNCTION(maxdb_rpl_query_type);
PHP_FUNCTION(maxdb_dump_debug_info);
PHP_FUNCTION(maxdb_embedded_connect);
PHP_FUNCTION(maxdb_select_db);
PHP_FUNCTION(maxdb_stat);
PHP_FUNCTION(maxdb_thread_id);
PHP_FUNCTION(maxdb_get_proto_info);
PHP_FUNCTION(maxdb_get_server_info);
PHP_FUNCTION(maxdb_server_init);
PHP_FUNCTION(maxdb_server_end);
PHP_FUNCTION(maxdb_get_server_version);
PHP_FUNCTION(maxdb_get_client_info);
PHP_FUNCTION(maxdb_get_client_version);
PHP_FUNCTION(maxdb_get_host_info);
PHP_FUNCTION(maxdb_autocommit);
PHP_FUNCTION(maxdb_report);
PHP_FUNCTION(maxdb_options);
PHP_FUNCTION(maxdb_init);
PHP_FUNCTION(maxdb_real_connect);
PHP_FUNCTION(maxdb_ssl_set);
PHP_FUNCTION(maxdb_connect);
PHP_FUNCTION(maxdb_connect_errno);
PHP_FUNCTION(maxdb_connect_error);
PHP_FUNCTION(maxdb_rollback);
PHP_FUNCTION(maxdb_kill);
PHP_FUNCTION(maxdb_change_user);
PHP_FUNCTION(maxdb_insert_id);
PHP_FUNCTION(maxdb_real_escape_string);
PHP_FUNCTION(maxdb_query);
PHP_FUNCTION(maxdb_send_query);
PHP_FUNCTION(maxdb_real_query);
PHP_FUNCTION(maxdb_master_query);
PHP_FUNCTION(maxdb_multi_query);
PHP_FUNCTION(maxdb_store_result);
PHP_FUNCTION(maxdb_use_result);
PHP_FUNCTION(maxdb_next_result);
PHP_FUNCTION(maxdb_more_results);
PHP_FUNCTION(maxdb_sqlstate);
PHP_FUNCTION(maxdb_prepare);
PHP_FUNCTION(maxdb_stmt_init);
PHP_FUNCTION(maxdb_stmt_prepare);
PHP_FUNCTION(maxdb_stmt_execute);
PHP_FUNCTION(maxdb_stmt_errno);
PHP_FUNCTION(maxdb_stmt_error);
PHP_FUNCTION(maxdb_stmt_affected_rows);
PHP_FUNCTION(maxdb_stmt_sqlstate);
PHP_FUNCTION(maxdb_stmt_param_count);
PHP_FUNCTION(maxdb_stmt_num_rows);
PHP_FUNCTION(maxdb_stmt_bind_param);
PHP_FUNCTION(maxdb_stmt_bind_result);
PHP_FUNCTION(maxdb_stmt_fetch);
PHP_FUNCTION(maxdb_stmt_data_seek);
PHP_FUNCTION(maxdb_stmt_send_long_data);
PHP_FUNCTION(maxdb_stmt_close_long_data);
PHP_FUNCTION(maxdb_stmt_store_result);
PHP_FUNCTION(maxdb_stmt_free_result);
PHP_FUNCTION(maxdb_stmt_reset);
PHP_FUNCTION(maxdb_stmt_close);
PHP_FUNCTION(maxdb_stmt_result_metadata);
PHP_FUNCTION(maxdb_free_result);
PHP_FUNCTION(maxdb_data_seek);
PHP_FUNCTION(maxdb_fetch_row);
PHP_FUNCTION(maxdb_fetch_assoc);
PHP_FUNCTION(maxdb_fetch_array);
PHP_FUNCTION(maxdb_fetch_object);
PHP_FUNCTION(maxdb_num_fields);
PHP_FUNCTION(maxdb_num_rows);
PHP_FUNCTION(maxdb_fetch_field);
PHP_FUNCTION(maxdb_fetch_fields);
PHP_FUNCTION(maxdb_fetch_field_direct);
PHP_FUNCTION(maxdb_fetch_lengths);
PHP_FUNCTION(maxdb_field_count);
PHP_FUNCTION(maxdb_field_seek);
PHP_FUNCTION(maxdb_field_tell);
PHP_FUNCTION(maxdb_affected_rows);
PHP_FUNCTION(maxdb_info);
PHP_FUNCTION(maxdb_character_set_name);
PHP_FUNCTION(maxdb_ping);
PHP_FUNCTION(maxdb_error);
PHP_FUNCTION(maxdb_errno);
PHP_FUNCTION(maxdb_warning_count);
PHP_FUNCTION(maxdb_close);
PHP_FUNCTION(maxdb_commit);

/* 
  	Declare any global variables you may need between the BEGIN
	and END macros here:     */

ZEND_BEGIN_MODULE_GLOBALS(maxdb)
	char                     *default_host;      /* default hostname for connect */
	char                     *default_db;        /* default databasename for connect */   
	char                     *default_user;      /* default username for connect */
	char                     *default_pw;        /* default password for connect */
	char                     *db;                /* current database used in connection */
	char                     *user;              /* current user used in connection */
	char                     *password;          /* current password used in connection */
	SQLDBC_Environment       *m_maxDBEnv;        /* SQLDBC environment */
	int                       report_mode;       /* error reporting mode */
	SQLDBC_UInt4              long_readlen;      /* max. length of long data to read */
	int                       error_no;          /* error number from last query */
	char                     *error_msg;         /* error message from last query */
	SQLDBC_ConnectProperties *conn_prop;         /* SQLDBC connect properties */
	SQLDBC_ConnectProperties *trace_prop;        /* SQLDBC trace properties */
	int                       ssl_error;         /* whether ssl errors should be reported */
	SQLDBC_UInt4              thread_id;         /* thread id count for connections */
    char                      messbuf[1024];
ZEND_END_MODULE_GLOBALS(maxdb)


/* In every utility function you add that needs to use variables 
   in php_maxdb_globals, call TSRMLS_FETCH(); after declaring other 
   variables used by that function, or better yet, pass in TSRMLS_CC
   after the last function argument and declare your utility function
   with TSRMLS_DC after the last declared argument.  Always refer to
   the globals in your function as MAXDB_G(variable).  You are 
   encouraged to rename these macros something shorter, see
   examples in any other php module directory.
*/

#ifdef ZTS
#define MAXDB_G(v) TSRMG(maxdb_globals_id, zend_maxdb_globals *, v)
#else
#define MAXDB_G(v) (maxdb_globals.v)
#endif

#endif	/* PHP_MAXDB_H */


/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: noet sw=4 ts=4 fdm=marker
 * vim<600: noet sw=4 ts=4
 */
