#ifndef JOIN_RESULTSETAPPENDEREX_HPP
#define JOIN_RESULTSETAPPENDEREX_HPP
/*!
 * @file
 * @brief implements interface Join_IResultSetAppender; 
 * addnl. reset unused space in key
 *
 * @author GertG
 * @ingroup Join
 *
 * @par last changed by:
 * <br>
 * $Author: d024980 $ $DateTime: 2005/02/18 17:24:39 $
 *
 * @sa Join_Execute.cpp, Join_IResultSetAppender.hpp
 */
/*

    ========== licence begin  GPL
    Copyright (c) 2003-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/
#include "SAPDBCommon/SAPDB_MemCopyMove.hpp"
#include "Join/Join_IResultSetAppender.hpp"

class SQLMan_Context;

//! implements interface Join_IResultSetAppender; addnl. reset unused space in key
class Join_ResultSetAppenderEx : public Join_IResultSetAppender {
public:
    //! @name constructor / destructor
    //@{
    //! constructor
    /*! 
     * @param acv [in] global context
     * @param rec_desc [in] pointer to result record description
     * @param result_id [in] name of result file
     * @param rescnt [in] amount of records already in result set
     * @param maxrescnt [in] maximal amount of records in result set
     */
    Join_ResultSetAppenderEx( 
            SQLMan_Context&                 acv, 
            Join_StackListPtr&              rec_desc,
            tgg00_FileId&                   result_id, 
            const SAPDB_Int4&               rescnt,
            const SAPDB_Int4&               maxrescnt ) :
    Join_IResultSetAppender( acv, rec_desc, result_id, rescnt, maxrescnt )
    { 
        SAPDBTRACE_METHOD_DEBUG( "Join_ResultSetAppenderEx::ctor", Join_Trace, 1 );
    }

    //! destructor
    virtual ~Join_ResultSetAppenderEx(){}
    //@}

    //! @name manipulation of result set
    //@{
    //! add record to result set
    /*!
     * @param record [in] record to be added
     * @return information code <tt>[e_ok, e_no_next_record]</tt> / error code
     */
    virtual tgg00_BasisError Add( tgg00_Rec& record )
    {
        SAPDBTRACE_METHOD_DEBUG( "Join_ResultSetAppenderEx::Add", Join_Trace, 1 );
        if ( m_ResultCnt < m_MaxResultCnt )
        {
            // we have to fill in unused space
            SAPDB_MemFillNoCheck( &record.recKey_gg00().k(), 0x00, record.recKeyLen_gg00() - RESCNT_MXGG04 );
            return add( record );
        }
        return e_no_next_record;
    }
    //@}
};

#endif // JOIN_RESULTSETAPPENDEREX_HPP
