/****************************************************************************

  module      : Kernel_Dump.cpp

  -------------------------------------------------------------------------

  responsible : TorstenS

  special area: 
  description : 


  last changed: 2001-06-08  16:57
  see also    : 

  -------------------------------------------------------------------------

  copyright:    (c) 2001-2004 SAP AG

  ========== licence begin  GPL
  Copyright (c) 2001-2004 SAP AG

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  ========== licence end

*****************************************************************************/



/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "heo58.h"          // vtracewriter_alive

#include "KernelCommon/Kernel_Dump.hpp"

/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/



/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/



/*===========================================================================*
 *  LOCAL CLASSES, STRUCTURES, TYPES, UNIONS ...                             *
 *===========================================================================*/



/*===========================================================================*
 *  STATIC/INLINE FUNCTION PROTOTYPES                                        *
 *===========================================================================*/



/*===========================================================================*
 *  METHODS                                                                  *
 *===========================================================================*/

void 
Kernel_Dump::Flush()
{
    if( m_Page.IsUsed() )
    {
        vtracewriter_alive();
        m_Page.PrepareForWrite(); // fill the dump page with 0xFE
        m_File.Write( m_Page );
        m_Page.InitializeFrame();
    }
}

/*---------------------------------------------------------------------------*/

SAPDB_Bool
Kernel_Dump::InsertEntry(
                         Kernel_DumpEntryId             DumpEntryId,
                         const Kernel_DumpPage::Entry   &DumpEntry )
{
    if( m_File.ErrorOccured() )
        return( false );

    SAPDBERR_ASSERT_STATE(( DmpNil < DumpEntryId ) && ( DumpEntryId < DmpEnd ));

    if(
        ( m_Page.IsSpaceAvailable( DumpEntry.GetLength())) &&
        ( m_LastEntryId == DumpEntryId                  )
        )
    {
        return( m_Page.Insert( DumpEntry ));
    }

    Flush();
    
    m_Page.InitializeFrame( m_PageNo, Kernel_DumpInfo[ DumpEntryId ].dmpLabel, 
        Kernel_DumpInfo[ DumpEntryId ].dmpCode );
    
    m_LastEntryId = DumpEntryId;
    ++m_PageNo;

    return( m_Page.Insert( DumpEntry ));
}

/*---------------------------------------------------------------------------*/

SAPDB_Bool
Kernel_Dump::InsertPage( const Kernel_Page  &Page )
{
    if( m_File.ErrorOccured() )
        return( false );

    Flush();

    m_LastEntryId = DmpNil; // full page dumps has no label
    ++m_PageNo;

    return( m_Page.InsertPage( Page ));
}

/*===========================================================================*
 *  END OF CODE                                                              *
 *===========================================================================*/