/*!
    @file     Table_TempHashTable_PascalWrapper.cpp
    @ingroup  Table
    @author   DirkT
    @brief    Temporary hash table
    @see            

\if EMIT_LICENCE
    ========== licence begin  GPL
    Copyright (c) 2000-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end
\endif
*/

#include "ggg00.h"
#include "hbd101.h"
#include "gkb07.h"
#include "hkb721.h"
#include "vak001.h"

#include "SQLManager/SQLMan_Context.hpp"
#include "Table/Table_TempHashTable.hpp"

//-------------------------------------------------------------------------

class SQLMan_DataMerger : public Table_TempHashTableAggregate_IDataMerger
{
public:
    SQLMan_DataMerger( tgg00_MessBlock* messBlock, tgg07_select_param* selectParam )
        : pMessBlock(messBlock)
        , pSelectParam(selectParam)
    {
    }

    // derived from Table_TempHashTable_IDataMerger
    inline void MergeData( const SAPDB_Byte* Source, SAPDB_Byte* Destination, SAPDB_UInt2 Length, bool Found )
    {
        k721Merge_ForAggregate(pMessBlock, pSelectParam, (tgg00_VoidPtr) Source, Destination, Length, Found);
    }

private:
    tgg00_MessBlock*    pMessBlock;
    tgg07_select_param* pSelectParam;
};


//-------------------------------------------------------------------------

pasbool b101_TempHashTable_Create (
    tkb101_AggregateContextPtr  AggrContextPtr,
    tsp00_Int8                  ExpectedEntries)
{
    SAPDBTRACE_ROUTINE_DEBUG ("b101_TempHashTable_Create", Table_Trace, 1);
    SAPDBERR_ASSERT_STATE( AggrContextPtr != 0 );

    SAPDBMem_IRawAllocator& Alloc = *(REINTERPRET_CAST(SAPDBMem_IRawAllocator*, AggrContextPtr->pTransContext->trAllocator_gg00));

    tak_all_command_glob* pAcv = REINTERPRET_CAST(tak_all_command_glob*, AggrContextPtr->pTransContext->trAcvPtr_gg00);
    SAPDBErr_MessageList& ErrorList = SQLMan_Context::AcvToContext(*pAcv).GetErrorList();

    SQLMan_DataMerger* MergerPtr = 0;
    Table_FixSizeTempHashTableAggregate* TablePtr = 0;

    MergerPtr = new(Alloc) SQLMan_DataMerger(AggrContextPtr->pMessBlock, AggrContextPtr->pSelectParam);
    if ( MergerPtr )
    {
        tsp00_Int2  KeyCount;   
        tsp00_Int2  RecLength;
        SAPDB_Int2  FieldOffset[cak_maxkeyfields];  // cak_maxkeyfields = 512
        SAPDB_Int2  FieldLength[cak_maxkeyfields];  // cak_maxkeyfields = 512

        if ( k721GetKeyAndRecInfo_ForAggregate(RecLength, KeyCount, FieldOffset, FieldLength, cak_maxkeyfields) )
        {
            Table_FixSizeEntry_FieldDescription FieldDescription(Alloc);
            Table_FixSizeEntry_KeyNoList KeyNoList(Alloc);
            FieldDescription.Reserve(KeyCount);
            KeyNoList.Reserve(KeyCount);

            for ( SAPDB_Int2 i=0; i<KeyCount; i++)
            {
                Table_OffsetLengthTuple X;
                X.Offset = FieldOffset[i];
                X.Length = FieldLength[i];   
                KeyNoList.InsertEnd(i);
                FieldDescription.InsertEnd(X);
            }

            TablePtr  = new(Alloc) Table_FixSizeTempHashTableAggregate
                                    (
                                        *(AggrContextPtr->pTransContext), 
                                        *MergerPtr, 
                                        RecLength,
                                        FieldDescription,
                                        KeyNoList,
                                        ExpectedEntries,
                                        ErrorList
                                    );
            if ( TablePtr )
            {
                if ( TablePtr->CompletelyConstructed() )
                {
                    AggrContextPtr->pTable = TablePtr;
                    AggrContextPtr->pDataMerger = MergerPtr;
                    return true;
                }
            }
        }
    }
    if ( MergerPtr )
        destroy(MergerPtr, Alloc);
    if ( TablePtr )
        destroy(TablePtr, Alloc);
    AggrContextPtr->pTable = 0;
    AggrContextPtr->pDataMerger = 0;
    return false;
}

void b101_TempHashTable_Destroy (
    tkb101_AggregateContextPtr    AggrContextPtr )
{
    SAPDBTRACE_ROUTINE_DEBUG ("b101_TempHashTable_Destroy", Table_Trace, 1);
    SAPDBERR_ASSERT_STATE( AggrContextPtr != 0 );

    if ( AggrContextPtr->pTable )
    {
        SAPDBMem_IRawAllocator& Alloc = *(REINTERPRET_CAST(SAPDBMem_IRawAllocator*, AggrContextPtr->pTransContext->trAllocator_gg00));
        Table_FixSizeTempHashTableAggregate* TablePtr = REINTERPRET_CAST(Table_FixSizeTempHashTableAggregate*, AggrContextPtr->pTable);
        destroy(TablePtr, Alloc);
    }
}

pasbool b101_TempHashTable_InsertOrReplace (
    tkb101_AggregateContextPtr    AggrContextPtr,
    tgg00_VoidPtr         pRecord)
{
    SAPDBTRACE_ROUTINE_DEBUG ("b101_TempHashTable_InsertOrReplace", Table_Trace, 1);
    SAPDBERR_ASSERT_STATE( AggrContextPtr != 0 );

    if ( AggrContextPtr->pTable )
    {
        Table_FixSizeTempHashTableAggregate* TablePtr = REINTERPRET_CAST(Table_FixSizeTempHashTableAggregate*, AggrContextPtr->pTable);
        tak_all_command_glob* pAcv = REINTERPRET_CAST(tak_all_command_glob*, AggrContextPtr->pTransContext->trAcvPtr_gg00);
        SAPDBErr_MessageList& ErrorList = SQLMan_Context::AcvToContext(*pAcv).GetErrorList();
        
        return (TablePtr->InsertOrReplace((SAPDB_Byte*)pRecord, ErrorList));
    }
    return false;
}

pasbool b101_TempHashTable_GetFirst (
    tkb101_AggregateContextPtr    AggrContextPtr,
    tgg00_VoidPtr         VAR_VALUE_REF  record)
{
    SAPDBTRACE_ROUTINE_DEBUG ("b101_TempHashTable_GetFirst", Table_Trace, 1);
    SAPDBERR_ASSERT_STATE( AggrContextPtr != 0 );

    if ( AggrContextPtr->pTable )
    {
        Table_FixSizeTempHashTableAggregate* TablePtr = REINTERPRET_CAST(Table_FixSizeTempHashTableAggregate*, AggrContextPtr->pTable);
        tak_all_command_glob* pAcv = REINTERPRET_CAST(tak_all_command_glob*, AggrContextPtr->pTransContext->trAcvPtr_gg00);
        SAPDBErr_MessageList& ErrorList = SQLMan_Context::AcvToContext(*pAcv).GetErrorList();

        if ( TablePtr->First(ErrorList) )
        {
            record = TablePtr->Get();
            return true;
        }
    }
    return false;
}

pasbool b101_TempHashTable_GetNext (
    tkb101_AggregateContextPtr    AggrContextPtr,
    tgg00_VoidPtr         VAR_VALUE_REF  record)
{
    SAPDBTRACE_ROUTINE_DEBUG ("b101_TempHashTable_GetNext", Table_Trace, 1);
    SAPDBERR_ASSERT_STATE( AggrContextPtr != 0 );

    if ( AggrContextPtr->pTable )
    {
        Table_FixSizeTempHashTableAggregate* TablePtr = REINTERPRET_CAST(Table_FixSizeTempHashTableAggregate*, AggrContextPtr->pTable);

        if ( TablePtr->Next() )
        {
            record = TablePtr->Get();
            return true;
        }
    }
    return false;
}

pasbool b101_TempHashTable_ForceFlush (
    tkb101_AggregateContextPtr    AggrContextPtr )
{
    SAPDBTRACE_ROUTINE_DEBUG ("b101_TempHashTable_ForceFlush", Table_Trace, 1);
    SAPDBERR_ASSERT_STATE( AggrContextPtr != 0 );

    if ( AggrContextPtr->pTable )
    {
        Table_FixSizeTempHashTableAggregate* TablePtr = REINTERPRET_CAST(Table_FixSizeTempHashTableAggregate*, AggrContextPtr->pTable);
        tak_all_command_glob* pAcv = REINTERPRET_CAST(tak_all_command_glob*, AggrContextPtr->pTransContext->trAcvPtr_gg00);
        SAPDBErr_MessageList& ErrorList = SQLMan_Context::AcvToContext(*pAcv).GetErrorList();

        return (TablePtr->ForceFlushAndFreeMem(ErrorList));
    }
    return false;
}

//-------------------------------------------------------------------------
