#!/usr/bin/perl

use strict;
use integer;
use FileHandle;
use Class::Struct;

my %TABLE;

my %GENKEI = (
	      K5 => '',
	      C5 => '',
	      G5 => '',
	      S5 => '',
	      T5 => '',
	      N5 => '',
	      B5 => '',
	      M5 => '',
	      R5 => '',
	      L5 => '',
	      W5 => '',
	      U5 => '',
	      KS => '',
	      KX => '',
	      SX => '',
	      ZX => '',
	      NZX => '󤺤',
	      KY => '',	      
);

my %BASE = qw/ ̾ 200 ư 250 ƻ 250 ¾ 300 /;
&struct( hinshi => { ident => '$', freq => '$', spec => '$', noun => '@', katuyou => '$' } );
&make_table();
for my $file ( @ARGV ){
    &conv( $file );
}

sub conv {
    my $file = shift;
    my $fh = FileHandle->new( $file, "r" );
    while( <$fh> ){
	s/\s+$//;
	my( $ident, $score );
	my( $yomi, @buf ) = split( /\s+/, $_ );
	$yomi = &h2k( $yomi );
	for( @buf ){
	    if( m/^#([^*]+)(\*(\d+))?$/ ){
		$ident = lc($1);
		$score = $3;
	    } elsif( $TABLE{$ident}->spec ){
		my $midasi = $_;
		my $genkei = $_;
		my( $hinshi, $bunrui1, $bunrui2, $bunrui3, $gata, $katati )
		    = split( /,/, $TABLE{$ident}->spec );
		my $val = '';
		if ($gata) {
		    $val = $TABLE{$ident}->katuyou;
		    #print STDERR "$gata $ident $val\n";
		}
		next if $val eq '*';
		&pentry( $midasi.$val, $score,
			 join(",", $hinshi || '*',
			      $bunrui1 || '*',
			      $bunrui2 || '*',
			      $bunrui3 || '*',
			      $gata || '*'),
			 #$key,
			 #$midasi.$TABLE{$ident}->katuyou('ܷ'),
			 $yomi.&h2k($val),
			 $yomi.&h2k($val) );
	    }
	}
    }
}

sub pentry {
    my( $midasi, $score, $hinshi, @spec ) = @_;
#     $score = ( defined $BASE{$hinshi} ? $BASE{$hinshi} : $BASE{'¾'} ) - $score / 20 - length($midasi);
#     $score <= 0 and $score = 1;
    $score = 100 - length($midasi);
    my @hinshi = split(/,/, $hinshi);
    if (defined $hinshi[4] && $hinshi[4] ne '*') {
	my $katsuyou = pop @hinshi;
	$hinshi = join(',', @hinshi);
	$hinshi =~ s/,\*//g;
	$hinshi =~ s/,/ /g;
	printf( "(ʻ (%s)) ((Ф (%s %s)) (ɤ %s) (ѷ %s))\n", $hinshi,
		$midasi, $score, $spec[0], h2k($katsuyou));
    } else {
	$hinshi =~ s/,\*//g;
	$hinshi =~ s/,/ /g;
	printf( "(ʻ (%s)) ((Ф (%s %s)) (ɤ %s))\n", $hinshi,
		$midasi, $score, $spec[0]);
    }
}

# ʿ̾Ҳ̾Ѵؿ
sub h2k {
    my( $str ) = @_;
    my @buf;
    while( $str =~ s/^((?:[\xa1-\xfe][\xa1-\xfe]|[^\xa1-\xfe])*?)(\xa4([\xa1-\xf3])|)// ){
        push( @buf, $1 );
        push( @buf, $3 ? "\xa5".$3 : $2 );
    }
    join( '', ( @buf, $str ) );
}

# ܥץѴơ֥ɤ߹ؿ
sub make_table {
    while( <DATA> ){
	chomp;
	my( $ident, $freq, $spec, $noun ) = split( /\t/, $_ );
	my $new = new hinshi;
	$TABLE{$ident} = $new;
	$new->ident( $ident );
	$new->freq( $freq );
	$new->spec( $spec );
	$new->noun( split(/,/, $noun) );
	$ident =~ s/r$//;
	if( $GENKEI{uc($ident)} ){
	    my $val = $GENKEI{uc($ident)};
	    $new->katuyou( $val );
	    #print STDERR "$ident: $val\n";
	} else {
	    $new->katuyou( "*" );
	}
    }
}

# ʲϡCanna Ѥʻʬ ID 顤ipadic η(ɤ)ؤѴ
# ɽǤ롥1Ԥϡ
#
#	Canna-ID TAB  TAB IPADIC-spec TAB ̾첽-spec LF
#
# ȤˤʤäƤ롥
__DATA__
t35	57028	̾,,*,*
jns	14299	̾,ͭ̾,̾,
t30	11943	̾,³,*,*
jnm	7443	̾,ͭ̾,̾,̾
cn	5745	̾,ͭ̾,ϰ,*
kk	3051	̾,ͭ̾,ȿ,*
t05	2556	̾,ư촴,*,*
cns	2152	̾,ͭ̾,ϰ
kj	1966
t15	1464	̾,,*,*
okx	1352
t17	1063	̾,ư촴,*,*
ks	941	ư,Ω,*,*,
jn	806	̾,ͭ̾,̾,*
ky	761	ƻ,Ω,*,*,ƻ졦
r5	733	ư,Ω,*,*,ʡ
f14	672	,³,*,*
ksr	646	ư,Ω,*,*,	촴
s5	611	ư,Ω,*,*,ʡ
cj	568	ư,*,*,*
r5r	454	ư,Ω,*,*,ʡ	Ϣѷ
kyu	421	ƻ,Ω,*,*,ƻ졦,Ϣѥ³
f04	398	,³,*,*
js	375	̾,,,*
k5	281	ư,Ω,*,*,ʡԥ
f06	280	,,*,*
jnsuc	267	̾,,̾,*
s5r	258	ư,Ω,*,*,ʡ	Ϣѷ
m5	220	ư,Ω,*,*,ʡ޹
w5	204	ư,Ω,*,*,ʡԥ
m5r	202	ư,Ω,*,*,ʡ޹	Ϣѷ
rt	188	Ϣλ,*,*,*
w5r	168	ư,Ω,*,*,ʡԥ	Ϣѷ
k5r	144	ư,Ω,*,*,ʡԥ	Ϣѷ
pre	136	Ƭ,̾³,*,*
t16	132	̾,ư촴,*,*
t10	126	̾,³,*,*
nn	107	̾,,*,*
f02	103	̾,,*,*
n2t35	102	̾,,*,*
tkn	100
f12	93	,,*,*
sx	84	ư,Ω,*,*,ѡ
t5	70	ư,Ω,*,*,ʡ
n00	68	̾,,*,*
zx	64	
kymi	60	ƻ,Ω,*,*,ƻ졦	촴+
t00	54	̾,ư촴,*,*
kxya	47	ư,Ω,*,*,,
cnsuc2	46	̾,,ϰ,*
g5	42	ư,Ω,*,*,ʡ
kyme	42	ƻ,Ω,*,*,ƻ졦	촴+
g5r	40	ư,Ω,*,*,ʡ	Ϣѷ
cnsuc1	40	̾,,*,*,*
t06	35	̾,ư촴,*,*
b5	31	ư,Ω,*,*,ʡй
c5r	27	ư,Ω,*,*,ʡ¥إ楯	Ϣѷ
kxi	24	ư,Ω,*,*,,Ϣѷ
t5r	23	ư,Ω,*,*,ʡ	Ϣѷ
kxuru	23	ư,Ω,*,*,,ܷ
kymime	22	ƻ,Ω,*,*,ƻ졦	촴+,촴+
kxo	22	ư,Ω,*,*,,̤
kxoi	22	ư,Ω,*,*,,̿
kxure	21	ư,Ω,*,*,,
ztomo	20
n2t15	20	̾,,ư촴,*
t36	20	,,*,*
nnpre	19
n2t30	19	̾,,³,*
b5r	19	ư,Ω,*,*,ʡй	Ϣѷ
fttara	17
zno	16
fkn	15	,,*,*
n03	14	̾,,*,*
d2t35	13	̾,,ư촴,*
l5	11	ư,Ω,*,*,ʡ
n01	11	̾,,*,*
t07	11
n2t16	11	̾,,ư촴,*
n02	11	̾,,*,*
cnpre	10	Ƭ,̾³,*,*
yasui	9
zyo	9
t32	8
d2ky	8	̾,,ư촴,*
zkana	7
jssuc	7	̾,,,*
zkai	7
zzo	6
nainya	6
ddeha	6
nainee	6
kdya	6
n5	5	ư,Ω,*,*,ʡʹ
zya	5
u5	5
znee	5
zyona	4
n2t10	4	̾,,ư촴,*
znaa	4
zze	4
fbakari	4	,,*,*
fdeha	4
nai	4
jau	4
aru	4
skeredo	4
djan	4
fnazo	4	,,*,*
kykya	4
zmono	4
g5ya	3	ư,Ω,*,ʡ,
n5ya	3	ư,Ω,*,*,ʡʹ,
r5ya	3
m5ya	3	ư,Ω,*,*,ʡ޹,
ktya	3
t09	3
b5ya	3	ư,Ω,*,ʡй,
ktok5ya	3
t5ya	3
ksya	3	ư,Ω,촴̾,*,,
f00	3	̾,,*,*
k5ya	3	ư,Ω,*,ʡԥ,
s5ya	3
zkasira	3
zxya	3
zwa	3
t12	2
ddat	2	ư,*,*,*,ü졦,Ϣѥ³
kkara	2	,ʽ,*,*
ddaro	2	ư,*,*,*,ü졦,̤
fha	2	,,*,*
ddarou	2
ktemo	2
zsa	2
chau	2	ư,Ω,*,*,ʡ¥,ܷ
u5r	2
fsika	2	,,*,*
skara	2
zna	2
kte	2
zne	2
naisa	2
dda1	2	
sxya	2
dda2	2	
sugiru	2
sniha	1
sasiru	1
kteha	1
zi	1
jtnn	1	̾,Ω,,*
fttatte	1
ktaro	1
fnaradeha	1	̾,,,*
masen	1
zka	1
kke	1	,,*,*
nd2ky	1
ktok5i	1
ktok5io	1
ktok5e	1
kto	1
t08	1
ktok5a	1
sxe	1
ssu	1
sxeyo	1
smonowo	1
d2t16	1	̾,,ư촴,*
ktok5u	1
sxi	1
zni	1
sxu2	1
r5no	1
ktok5o	1
sxure	1
kta	1
snode	1
k5siru	1
ktara	1
ztto	1
siru	1
kyi	1
smonono	1
kdo	1
sxiro	1
ktari	1
jtno	1	̾,Ω,,*
sxuru	1
