/*
 * medussa - a distributed cracking system
 * Copyright (C) 1999 Kostas Evangelinos <kos@bastard.net>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

/*
 * $Id: portscan.h,v 1.1.1.1 2002/01/22 01:27:09 kos Exp $
 *
 */

#ifndef _PORTSCAN_H
#define _PORTSCAN_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <sys/types.h>
#include <sys/wait.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <sys/time.h>

#define PORTSCAN_CLAMP 2048
#define PORTSCAN_LINELEN 128

typedef struct portscan_result_t {
  char host[PORTSCAN_LINELEN];
  unsigned int port;
  unsigned char reply[PORTSCAN_LINELEN];
} portscan_result_t;

typedef struct portscan_t {
  unsigned int sock_limit;
  array *results;
  array *pool;
  struct sockaddr_in sa;
} portscan_t;

#endif /* _PORTSCAN_H */
