##############################################################################
#
# Memaid Superkaramba widget <Peter.Bienstman@ugent.be>
#
##############################################################################

from karamba import *
from pyqt_memaid.memaid_core import *
import random, time, os, string, sys, qt

try:
    sys.setappdefaultencoding("utf-8")
except:
    pass



##############################################################################
#
# Some dimensions of graphical elements in the widget.
#
##############################################################################

# Offsets.

x0 = 18 
y0 = 14

xn = 21
yn = 25

border = 2

# Window dimensions.

w  = 194
h  = 80 
h2 = 40



##############################################################################
#
# Global variables.
#
##############################################################################

item = None

new_question_immediately = False

new_question_interval = 10 # Minutes.

autosave_interval = 30 # Minutes.

# Status.

status = None

wait_for_answer   = 0
wait_for_grades   = 1
answer_graded     = 2
wait_for_question = 3
wait_for_new_reps = 4

# Text areas.

question      = None
answer        = None
status_window = None
launcher      = None

# Timers.

last_save   = time.time()
last_answer = time.time()

# pid's.

delay_pid  = 0
mode_pid   = 0
grade_pid  = 0
memaid_pid = 0
error_pid  = 0
 

##############################################################################
#
# formatText
#
##############################################################################

def formatText(widget, size, font, textname):
    changeTextSize(widget, textname, size)
    changeTextFont(widget, textname, font)
    changeTextColor(widget, textname, 0, 0, 0)



##############################################################################
#
# StatusWindow
#
##############################################################################

class StatusWindow:
 
    ##########################################################################
    #
    # __init__
    #
    ##########################################################################

    def __init__(self, widget):
        
        self.show_answer = createText(widget, 72, y0+2*h+border+13, 90, 13,
                                      "Show answer")
        formatText(widget, 12, "verdana", self.show_answer)
        attachClickArea(widget, self.show_answer)
    
        self.grade_answer = createText(widget, 53, y0+2*h+border+4, 130, 13,
                                       "Grade your answer:")
        formatText(widget, 12, "verdana", self.grade_answer)

        self.grades = []
        for i in range(6):
            self.grades.append(createText(widget, x0+31+25*i, y0+2*h+border+26,
                                          15, 13, str(i)))
            formatText(widget, 12, "verdana", self.grades[-1])
            attachClickArea(widget, self.grades[-1])   

        self.no_more_reps = createText(widget, 37, y0+2*h+border+14, 160, 18,
                                       "No scheduled repetitions")
        formatText(widget, 12, "verdana", self.no_more_reps)

        self.get_new_question = createText(widget, 35, y0+2*h+border+14,
                                           160,18,"Click to get new question")
        formatText(widget, 12, "verdana", self.get_new_question)
        attachClickArea(widget, self.get_new_question)
        
        self.failed_to_load = createText(widget, 35, y0+2*h+border+14,
                                       165,18,"Unable to open database")
        formatText(widget, 12, "verdana", self.failed_to_load)
                
        self.memaid_exits = createText(widget, 39, y0+2*h+border+14,
                                       166,18,"Click when MemAid exits")
        formatText(widget, 12, "verdana", self.memaid_exits)
        attachClickArea(widget, self.memaid_exits)
        
        self.clear_text(widget)

    ##########################################################################
    #
    # clear_text
    #
    ##########################################################################

    def clear_text(self, widget):
        
        hideText(widget, self.show_answer)
        hideText(widget, self.grade_answer)
        for i in range(6):
            hideText(widget, self.grades[i])
        hideText(widget, self.no_more_reps)
        hideText(widget, self.get_new_question)
        hideText(widget, self.failed_to_load)
        hideText(widget, self.memaid_exits)



##############################################################################
#
# load
#
##############################################################################

def load(widget, path):

    if question != None:
        deleteRichText(widget, question)
    if answer != None:
        deleteRichText(widget, answer)
    status_window.clear_text(widget)
    
    status = load_database(path)

    if status == False:
        showText(widget, status_window.failed_to_load)
    else:
        set_config("path", path)

    return status


    
##############################################################################
#
# new_question
#
##############################################################################

def new_question(widget):
    
    global item, question, status

    item = get_new_question()

    if item == None:
        status_window.clear_text(widget)
        showText(widget, status_window.no_more_reps)
        status = wait_for_new_reps
    else:
        showText(widget, status_window.show_answer)
        question = print_Q_A(widget, item.q)
        status = wait_for_answer



##############################################################################
#
# print_Q_A
#
##############################################################################

def print_Q_A(widget, text, bottom_window=False):

    label = None
    text_h = 0
    
    for level in range(2,7): # Decreases size until it fits.
    
        label = createRichText(widget,escape("<center><h"+str(level)+">"
                               +"<font color=\"black\">"+text+"</font>"
                               +"</h"+str(level)+"></center>").encode('utf-8'))

        setRichTextWidth(widget, label, w)
        text_h = getRichTextSize(widget, label)[1]

        if text_h < h or level == 6:
            break
        else:
            deleteRichText(widget, label)

    if bottom_window == False:
        moveRichText(widget, label, x0, int( y0 + (h-text_h)/2.))
    else:
        moveRichText(widget, label, x0, int(y0 + h+border + (h-text_h)/2.))
    
    return label



##############################################################################
#
# initWidget
#
##############################################################################

def initWidget(widget):

    global status_window, new_question_interval
    global new_question_immediately, launcher

    ##########################################################################
    #
    # Create text lables in advance.
    #
    ##########################################################################

    createBackgroundImage(widget, 0, 0, "pixmaps/bg.png")
    status_window = StatusWindow(widget)
    status_window.clear_text(widget)
    
    ##########################################################################
    #
    # Create button to launch MemAid.
    #
    ##########################################################################
    
    launcher = createImage(widget, 199, 18, "pixmaps/arrow.png")
    tooltip  = createImage(widget, 199, 18, "pixmaps/tooltip.png")
    addImageTooltip(widget, tooltip, "Launch MemAid")
    attachClickArea(widget, launcher)
    
    ##########################################################################
    #
    # Create configuration menu.
    #
    ##########################################################################

    addMenuConfigOption(widget, "load", "Load new database")
    setMenuConfigOption(widget, "load", "1") 
        
    #addMenuConfigOption(widget, "add", "Add items")
    
    addMenuConfigOption(widget, "delay", "Set delay between questions")
    setMenuConfigOption(widget, "delay", "0")
    delay = readConfigEntry(widget, "delay")
    if delay != None:
        new_question_interval = delay
        
    if new_question_interval == 0:
        new_question_immediately = True
    else:
        new_question_immediately = False

    addMenuConfigOption(widget, "mode", "Set learning mode")
    setMenuConfigOption(widget, "mode", "0")
        
    addMenuConfigOption(widget, "grade", "Set threshold grade")
    setMenuConfigOption(widget, "grade", "0")
        
    addMenuConfigOption(widget, "hidelauncher", "Hide MemAid launch icon")
    if readMenuConfigOption(widget, "hidelauncher") == 1:
        hideImage(widget, launcher)
     
    addMenuConfigOption(widget, "viewdoc", "View documentation")
    setMenuConfigOption(widget, "viewdoc", "0")
    
    ##########################################################################
    #   
    # Initialise.
    #
    ##########################################################################

    if not os.path.exists(os.path.expanduser("~/.memaid")):
        os.mkdir(os.path.expanduser("~/.memaid"))
    
    if not os.path.exists(os.path.expanduser("~/.memaid/config")):
        save_config()
    
    if not os.path.exists(os.path.expanduser("~/.memaid/default.mem")):
        new_database(os.path.expanduser("~/.memaid/default.mem"))

    set_data_dir(os.path.expanduser("~/.memaid"))

    unload_database()
         
    load_config()

    if load(widget, get_config("path")) == True:
        new_question(widget)
         
    redrawWidget(widget)



##############################################################################
#
# meterClicked
#
##############################################################################

def meterClicked(widget, meter, button):

    global status, answer, memaid_pid

    ##########################################################################
    #
    # MemAid launcher clicked.
    #
    ##########################################################################
    
    if meter == launcher:
        
        status_window.clear_text(widget)
        if question != None:
            deleteRichText(widget, question)
        if answer != None:
            deleteRichText(widget, answer)
        status_window.clear_text(widget)

        hideImage(widget, launcher)

        save_database(get_config("path"))
        save_config()
        unload_database()

        showText(widget, status_window.memaid_exits)

        # Bug in Superkaramba: exit of MemAid is not detected.
        
        memaid_pid = executeInteractive(widget, ["pyqt_memaid",
                                                 get_config("path"),
                                                 str(item.id)])
        
        return
        
    ##########################################################################
    #
    # 'MemAid exits' clicked.
    #
    ##########################################################################
    
    if meter == status_window.memaid_exits:

        status_window.clear_text(widget)

        showImage(widget, launcher)

        load_config()
        load_database(get_config("path"))

        new_question(widget)
        redrawWidget(widget)

        return

    ##########################################################################
    #
    # 'Get new question' clicked.
    #
    ##########################################################################
    
    if meter == status_window.get_new_question:

        deleteRichText(widget, question)
        deleteRichText(widget, answer)
        status_window.clear_text(widget)
        
        new_question(widget)
        
        return

    ##########################################################################
    #
    # 'Show answer' clicked.
    #
    ##########################################################################
    
    if status == wait_for_answer:

        answer = print_Q_A(widget, item.a, bottom_window=True)
    
        status_window.clear_text(widget)
        showText(widget, status_window.grade_answer)   
        for i in range(len(status_window.grades)):
            showText(widget, status_window.grades[i])

        status = wait_for_grades
        
        return
        
    ##########################################################################
    #
    # Grades clicked.
    #
    ##########################################################################
    
    if status == wait_for_grades:
        
        grade = 0
        for grade in range(len(status_window.grades)):
            if meter == status_window.grades[grade]:
                break

        global last_answer
        last_answer = time.time()
        process_answer(item, grade)

        status_window.clear_text(widget)
        
        # Get new question.

        if new_question_immediately == True:
            
            deleteRichText(widget, question)
            deleteRichText(widget, answer)    
            new_question(widget)

        else:
            
            showText(widget, status_window.get_new_question)
            status = wait_for_question
        
        return



##############################################################################
#
# widgetUpdated
#
##############################################################################

def widgetUpdated(widget):

    global last_save, last_answer 

    now = time.time()

    # Autosaving.
    
    if (now - last_save) / 60 > autosave_interval:
        save_database(get_config("path"))
        last_save = now

    # Show new question.

    if (status == wait_for_question or status == wait_for_new_reps) \
           and (now - last_answer) / 60 > new_question_interval:
        
        last_answer = now
        
        train_ann_for_x_secs(1)

        if question != None:
            deleteRichText(widget, question)
        if answer != None:
            deleteRichText(widget, answer)
        status_window.clear_text(widget)
        
        new_question(widget)



##############################################################################
#
# menuOptionChanged
#
##############################################################################

def menuOptionChanged(widget, key, value):

    global load_pid, delay_pid, mode_pid, grade_pid, error_pid

    ##########################################################################
    #
    # Load.
    #
    ##########################################################################
    
    if key == "load":
        setMenuConfigOption(widget, "load", "0")
        load_pid = executeInteractive(widget,
             ["kdialog","--getopenfilename", get_config("path"),"*.mem"])

    ##########################################################################
    #
    # Add items.
    #
    ##########################################################################
    
    if key == "add":
        from add_items_dlg import AddElementsDlg
        setMenuConfigOption(widget, "add", "0")

        dlg = AddElementsDlg()
        dlg.exec_loop()

        # Sometimes crashes horribly. Too bad...
    
    ##########################################################################
    #
    # Delay between questions.
    #
    ##########################################################################
        
    if key == "delay":
        setMenuConfigOption(widget, "delay", "0")
        delay_pid = executeInteractive(widget,
             ["kdialog","--title", "Set delay between questions",
              "--inputbox","Enter the delay between questions (in minutes).",
              str(new_question_interval)])
        
    ##########################################################################
    #
    # Learning mode.
    #
    ##########################################################################

    if key == "mode":
        setMenuConfigOption(widget, "mode", "0")

        command = ["kdialog","--title", "",
              "--radiolist", "Set learning mode:"]
        if get_config("drill_badly_known") == 0:
            command.append("0")
            command.append("Optimally scheduled")
            command.append("on")
            command.append("1")
            command.append("Drill badly known")
            command.append("off")
        else:
            command.append("0")
            command.append("Optimally scheduled")
            command.append("off")
            command.append("1")
            command.append("Drill badly known")
            command.append("on")
     
        mode_pid = executeInteractive(widget, command)
    
    ##########################################################################
    #
    # Threshold grade.
    #
    ##########################################################################
    
    if key == "grade":
        setMenuConfigOption(widget, "grade", "0")
        
        command = ["kdialog","--title", "",
              "--radiolist", "All items <= this grade will be \n" \
                   +"reviewed in 'drill badly known'."]
        
        for i in range(0,6):
            command.append(str(i))
            command.append(str(i)) 
            if i == get_config("threshold"):
                command.append("on")
            else:
                command.append("off")
              
        grade_pid = executeInteractive(widget, command)
        
    ##########################################################################
    #
    # Hide MemAid launch icon.
    #
    ##########################################################################

    if key == "hidelauncher":
        if readMenuConfigOption(widget, "hidelauncher") == 1:
            hideImage(widget, launcher)
        else:
            showImage(widget, launcher)
            
        redrawWidget(widget)
        
    ##########################################################################
    #
    # View documentation.
    #
    ##########################################################################
    
    if key == "viewdoc":
        setMenuConfigOption(widget, "viewdoc", "0")
        os.system('kfmclient openURL ./docs/memaid_superkaramba.html &')



##############################################################################
#
# commandOutput.
#
##############################################################################

def commandOutput(widget, pid, output):

    global error_pid, new_question_interval, new_question_immediately

    ##########################################################################
    #
    # MemAid exits.
    #
    #   Bug in superkarama: this function is not always fired, but
    #   when it is, for some strange reason the exit routine of
    #   PyQt doesn't get called, so don't load the database twice.
    #
    ##########################################################################
    
    if pid == memaid_pid:

        print "Detected exit of MemAid"

        status_window.clear_text(widget)

        showImage(widget, launcher)

        load_config()
        load_database(get_config("path"))

        new_question(widget)    
        redrawWidget(widget)

        return

    if output == None or string.strip(output) == None:
        return

    ##########################################################################
    #
    # Load new database.
    #
    ##########################################################################
    
    if pid == load_pid:
        save_database(get_config("path"))
        train_ann_for_x_secs(1)
        unload_database()
        if load(widget, output[:-1]) == True:
            new_question(widget)

        redrawWidget(widget)
            
    ##########################################################################
    #
    # Delay between questions.
    #
    ##########################################################################
    
    if pid == delay_pid:
        try:
            delay = int(output)
        except:
            error_pid = executeInteractive(widget,["kdialog","--error",
                                                   "Invalid input!"])

        new_question_interval = delay

        if new_question_interval == 0:
            new_question_immediately = True
        else:
            new_question_immediately = False
        
        writeConfigEntry(widget, "delay", str(delay))
        
        if status == wait_for_question:
            status_window.clear_text(widget)
            deleteRichText(widget, question)
            deleteRichText(widget, answer)    
            new_question(widget)           
            redrawWidget(widget)

    ##########################################################################
    #
    # Learning mode.
    #
    ##########################################################################
    
    if pid == mode_pid:
        rebuild_revision_queue()
        if string.strip(output) == "0":
            set_config("drill_badly_known", False)
        else:
            set_config("drill_badly_known", True)
            if status == wait_for_new_reps:
                status_window.clear_text(widget)
                if question != None:
                    deleteRichText(widget, question)
                if answer != None:
                    deleteRichText(widget, answer)
                if not in_revision_queue(item):
                    new_question(widget)           
                redrawWidget(widget)            

    ##########################################################################
    #
    # Threshold grade.
    #
    ##########################################################################

    if pid == grade_pid:
        set_config("threshold", int(output))
        rebuild_revision_queue()
        if not in_revision_queue(item):
            new_question(widget)



##############################################################################
#
# widgetClosed.
#
##############################################################################

def widgetClosed(widget):
    save_database(get_config("path"))
    save_config()
    train_ann_for_x_secs(1)
    unload_database()



##############################################################################
#
# Unused callbacks.
#
##############################################################################

def widgetClicked(widget, x, y, button):
    pass

def widgetMouseMoved(widget, x, y, button):
    pass



##############################################################################
#
# This code will be executed when the widget loads.
#
##############################################################################

print "Loaded MemAid widget."


