use strict;
use FileHandle;

my @chars    = ();
my @patterns = ();

{
    my $fh = new FileHandle;
    $fh->open($ARGV[0]) || die;
    while (<$fh>) {
	chomp;
	push @chars, $_;
    }
}

{
    my $fh = new FileHandle;
    $fh->open($ARGV[1]) || die;
    while (<$fh>) {
	chomp;
	push @patterns, $_;
    }
}

if (@chars != @patterns) {
    die "@chars and @patterns differ."
}


print <<'EOM';
package migemo_cache;
%cache = ();
EOM

while (@chars) {
    my $char = shift @chars;
    my $pat  = shift @patterns;
    $pat =~ s/\\/\\\\/g;

    print "    \$cache{\"$char\"} = \"$pat\";\n";
}

print <<'EOM';
sub load {
    return %cache;
}
1;
EOM

