#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <linux/soundcard.h>

unsigned char ulaw_to_Alaw[256] = {
     0x2a, 0x2b, 0x28, 0x29, 0x2e, 0x2f, 0x2c, 0x2d,
     0x22, 0x23, 0x20, 0x21, 0x26, 0x27, 0x24, 0x25,
     0x3a, 0x3b, 0x38, 0x39, 0x3e, 0x3f, 0x3c, 0x3d,
     0x32, 0x33, 0x30, 0x31, 0x36, 0x37, 0x34, 0x35,
     0x0b, 0x08, 0x09, 0x0e, 0x0f, 0x0c, 0x0d, 0x02,
     0x03, 0x00, 0x01, 0x06, 0x07, 0x04, 0x05, 0x1a,
     0x1b, 0x18, 0x19, 0x1e, 0x1f, 0x1c, 0x1d, 0x12,
     0x13, 0x10, 0x11, 0x16, 0x17, 0x14, 0x15, 0x6b,
     0x68, 0x69, 0x6e, 0x6f, 0x6c, 0x6d, 0x62, 0x63,
     0x60, 0x61, 0x66, 0x67, 0x64, 0x65, 0x7b, 0x79,
     0x7e, 0x7f, 0x7c, 0x7d, 0x72, 0x73, 0x70, 0x71,
     0x76, 0x77, 0x74, 0x75, 0x4b, 0x49, 0x4f, 0x4d,
     0x42, 0x43, 0x40, 0x41, 0x46, 0x47, 0x44, 0x45,
     0x5a, 0x5b, 0x58, 0x59, 0x5e, 0x5f, 0x5c, 0x5d,
     0x52, 0x52, 0x53, 0x53, 0x50, 0x50, 0x51, 0x51,
     0x56, 0x56, 0x57, 0x57, 0x54, 0x54, 0x55, 0xd5,
     0xaa, 0xab, 0xa8, 0xa9, 0xae, 0xaf, 0xac, 0xad,
     0xa2, 0xa3, 0xa0, 0xa1, 0xa6, 0xa7, 0xa4, 0xa5,
     0xba, 0xbb, 0xb8, 0xb9, 0xbe, 0xbf, 0xbc, 0xbd,
     0xb2, 0xb3, 0xb0, 0xb1, 0xb6, 0xb7, 0xb4, 0xb5,
     0x8b, 0x88, 0x89, 0x8e, 0x8f, 0x8c, 0x8d, 0x82,
     0x83, 0x80, 0x81, 0x86, 0x87, 0x84, 0x85, 0x9a,
     0x9b, 0x98, 0x99, 0x9e, 0x9f, 0x9c, 0x9d, 0x92,
     0x93, 0x90, 0x91, 0x96, 0x97, 0x94, 0x95, 0xeb,
     0xe8, 0xe9, 0xee, 0xef, 0xec, 0xed, 0xe2, 0xe3,
     0xe0, 0xe1, 0xe6, 0xe7, 0xe4, 0xe5, 0xfb, 0xf9,
     0xfe, 0xff, 0xfc, 0xfd, 0xf2, 0xf3, 0xf0, 0xf1,
     0xf6, 0xf7, 0xf4, 0xf5, 0xcb, 0xc9, 0xcf, 0xcd,
     0xc2, 0xc3, 0xc0, 0xc1, 0xc6, 0xc7, 0xc4, 0xc5,
     0xda, 0xdb, 0xd8, 0xd9, 0xde, 0xdf, 0xdc, 0xdd,
     0xd2, 0xd2, 0xd3, 0xd3, 0xd0, 0xd0, 0xd1, 0xd1,
     0xd6, 0xd6, 0xd7, 0xd7, 0xd4, 0xd4, 0xd5, 0xd5,
    
};

unsigned char Alaw_to_ulaw[256] = {
     0x29, 0x2a, 0x27, 0x28, 0x2d, 0x2e, 0x2b, 0x2c,
     0x21, 0x22, 0x1f, 0x20, 0x25, 0x26, 0x23, 0x24,
     0x39, 0x3a, 0x37, 0x38, 0x3d, 0x3e, 0x3b, 0x3c,
     0x31, 0x32, 0x2f, 0x30, 0x35, 0x36, 0x33, 0x34,
     0x0a, 0x0b, 0x08, 0x09, 0x0e, 0x0f, 0x0c, 0x0d,
     0x02, 0x03, 0x00, 0x01, 0x06, 0x07, 0x04, 0x05,
     0x1a, 0x1b, 0x18, 0x19, 0x1e, 0x1f, 0x1c, 0x1d,
     0x12, 0x13, 0x10, 0x11, 0x16, 0x17, 0x14, 0x15,
     0x62, 0x63, 0x60, 0x61, 0x66, 0x67, 0x64, 0x65,
     0x5d, 0x5d, 0x5c, 0x5c, 0x5f, 0x5f, 0x5e, 0x5e,
     0x74, 0x76, 0x70, 0x72, 0x7c, 0x7e, 0x78, 0x7a,
     0x6a, 0x6b, 0x68, 0x69, 0x6e, 0x6f, 0x6c, 0x6d,
     0x48, 0x49, 0x46, 0x47, 0x4c, 0x4d, 0x4a, 0x4b,
     0x40, 0x41, 0x3f, 0x3f, 0x44, 0x45, 0x42, 0x43,
     0x56, 0x57, 0x54, 0x55, 0x5a, 0x5b, 0x58, 0x59,
     0x4f, 0x4f, 0x4e, 0x4e, 0x52, 0x53, 0x50, 0x51,
     0xa9, 0xaa, 0xa7, 0xa8, 0xad, 0xae, 0xab, 0xac,
     0xa1, 0xa2, 0x9f, 0xa0, 0xa5, 0xa6, 0xa3, 0xa4,
     0xb9, 0xba, 0xb7, 0xb8, 0xbd, 0xbe, 0xbb, 0xbc,
     0xb1, 0xb2, 0xaf, 0xb0, 0xb5, 0xb6, 0xb3, 0xb4,
     0x8a, 0x8b, 0x88, 0x89, 0x8e, 0x8f, 0x8c, 0x8d,
     0x82, 0x83, 0x80, 0x81, 0x86, 0x87, 0x84, 0x85,
     0x9a, 0x9b, 0x98, 0x99, 0x9e, 0x9f, 0x9c, 0x9d,
     0x92, 0x93, 0x90, 0x91, 0x96, 0x97, 0x94, 0x95,
     0xe2, 0xe3, 0xe0, 0xe1, 0xe6, 0xe7, 0xe4, 0xe5,
     0xdd, 0xdd, 0xdc, 0xdc, 0xdf, 0xdf, 0xde, 0xde,
     0xf4, 0xf6, 0xf0, 0xf2, 0xfc, 0xfe, 0xf8, 0xfa,
     0xea, 0xeb, 0xe8, 0xe9, 0xee, 0xef, 0xec, 0xed,
     0xc8, 0xc9, 0xc6, 0xc7, 0xcc, 0xcd, 0xca, 0xcb,
     0xc0, 0xc1, 0xbf, 0xbf, 0xc4, 0xc5, 0xc2, 0xc3,
     0xd6, 0xd7, 0xd4, 0xd5, 0xda, 0xdb, 0xd8, 0xd9,
     0xcf, 0xcf, 0xce, 0xce, 0xd2, 0xd3, 0xd0, 0xd1,
};


int main(argc,argv)
int argc;
char *argv[];
{
	int	audio_out;
	int	mISDN_in;
	int	format;
	int	cnt, wcnt, i;
	int	n,sel;
	fd_set  fdr;
	unsigned char buf[128];

	if (argc<=1)
		exit(1);
	audio_out = open("/dev/audio", O_WRONLY | O_NONBLOCK);
	if (0 > audio_out) {
		fprintf(stderr, "cannot open /dev/audio for write:%s\n",
			strerror(errno));
		exit(1);
	}
	mISDN_in = open(argv[1], O_RDONLY | O_NONBLOCK);
	if (0 > mISDN_in) {
		close(audio_out);
		fprintf(stderr, "cannot open %s for read:%s\n",
			argv[1], strerror(errno));
		exit(1);
	}
	format = AFMT_MU_LAW;
	fprintf(stdout, "audio format %x\n", format);
	if (ioctl(audio_out, SNDCTL_DSP_SETFMT, &format) == -1) {
		fprintf(stderr, "ioctl SNDCTL_DSP_SETFMT %s\n",
			strerror(errno));
	} else
		fprintf(stdout, "audio format %x\n", format);
	while(1) {
		cnt = read(mISDN_in, buf, 128);
		fprintf(stdout,	"mISDN_in %d bytes\n", cnt);
		if (cnt>0) {
			for (i=0;i<cnt;i++)
				buf[i] = Alaw_to_ulaw[buf[i]];
			wcnt = write(audio_out, buf, cnt);
			fprintf(stdout, "audio_out%d bytes\n", wcnt);
		} else if (errno == EAGAIN) {
			FD_ZERO(&fdr);
			FD_SET(mISDN_in, &fdr);
			n = mISDN_in;
			n++;
			sel = select(n, &fdr, NULL, NULL, NULL);
			if (sel<1) {
				fprintf(stdout, "sel %d : %s\n",
					sel, strerror(errno)); 
				break;
			}
		} else {
			fprintf(stdout, "mISDN_in: %s\n",
				strerror(errno));
			break;
		}
	}
	close(audio_out);
	close(mISDN_in);
}
