(*
 * $Id: error.ml,v 1.2 2002/03/21 16:45:39 monate Exp $

    Copyright (c) 1999 Christian Lindig <lindig@ips.cs.tu-bs.de>. All
    rights reserved. See COPYING for details.
 *
 * Global error and warning treatment.
 *)


(* The universal error exception
 *)

exception Error of string

(* [error] raises [Error]
 *)

let error msg	= raise (Error msg)

(* [warning] issues a warning to stderr
 *)

let quiet = ref false

let verbose = ref 0

let warning msg = if not !quiet then prerr_endline ("warning: " ^ msg)



