#ifndef DIRECTORY_H
#define DIRECTORY_H

#include <sys/types.h>
#include <vector>
#include <string>

#include "Tools.h"

//----------------------------------------------------------------------------
class Directory
{
  public:
    //------------------------------------------------------------------------
    typedef std::vector<std::string> FileList;

    //------------------------------------------------------------------------
    Directory();
    Directory(const char *name);
    ~Directory();

    //------------------------------------------------------------------------
    void read(const char *name);

    //------------------------------------------------------------------------
    const char *getName() const;

    //------------------------------------------------------------------------
    bool hasDirectory(const char *name) const;
    bool hasFile(const char *name) const;

    //------------------------------------------------------------------------
    void getFilesWithSuffix(const char* suffix, FileList &list) const;

    //------------------------------------------------------------------------
    static bool hasDirectoryInCwd(const char *name);

    static bool hasFileInCwd(const char *name);

    static void chdir(const char *name);

    static void mkdir(const char *name,
                      mode_t mode = 0755,
                      bool recursive = false);

    static void rmdir(const char *name, bool recursive = false);

    static void copy(const char *src, const char *dst);


    //------------------------------------------------------------------------
    DECLARE_PIMPL;
};

#endif //DIRECTORY_H
