#ifndef MENU_MANAGER_H
#define MENU_MANAGER_H

#include <cassert>
#include <pgapplication.h>
#include <pgthemewidget.h>

#include "Tools.h"
#include "MenuIds.h"

class Menu;

class MenuManager
{
  public:

    static void init(const char* layout, const char* theme);

    static void initScreen(bool fullScreen);

    static void destroy();

    static MenuManager* getInstance()
    {
        assert(sm_instance != NULL);
        return sm_instance;
    }

    void changeTo(Menu* menu,
                  bool background = true,
                  bool overridePrevious = true);
    void hideAll();
    void redrawBackground();

    static PG_Widget* getWidgetById(int id);

  protected:

    MenuManager();
    MenuManager(MenuManager&);
    virtual ~MenuManager();
    void check(PG_Widget* w, int id);

    static MenuManager* sm_instance;

    PG_Application* m_app;

    Menu* m_current;
    PG_ThemeWidget *m_background;
};

#endif // MENU_MANAGER_H
