#!/usr/bin/perl

use strict;
use Getopt::Long;

my $mnFile;
my $jarFile;
my %files;
my $tmpdir = "tmpjar";

my $res = GetOptions('mnfile=s' => \$mnFile, 'jarfile=s' => \$jarFile);

die("Mauvais parametres lignes de commande") if (!$res);

if (!$mnFile || !$jarFile) {
  die("Argument manquant. Abandon.");
}

die("Impossible d'ouvrir le fichier de liste de fichiers") unless open(MNFILE, "$mnFile");

die("Impossible de crer le rpertoire temporaire. Existe-t'il dj ?") unless mkdir($tmpdir);

while (<MNFILE>) {
  chomp;
  s/^\s+//;
  s/\s+$//;

  # Skip comments & blank lines
  next if (/^\#/);
  next if (/^\s*$/);

  # Read key & data
  my($key, $value) = split(/,/, $_);
    
  # Strip out any remaining whitespace from key & value
  for ($key) {
    s/\s+$//;
  }
  for ($value) {
    s/^\s+//;
  }

  my $dstDir = $key;

  $dstDir =~ s/[^\/]*$//;

  system("mkdir -p $tmpdir/$dstDir") == 0 or die("Impossible de crer l'arborescence destination");

  system("cp $value $tmpdir/$key") == 0 or die("Erreur lors de la copie d'un fichier");
}

close(MNFILE);

chdir($tmpdir) or die("Impossible de se placer dans le rpertoire temporaire");

system("zip -0 -r -D -m -T ../$jarFile *") == 0 or die("Impossible de crer l'archive jar.");

chdir("..");

system("rm -r $tmpdir") == 0 or die("Impossible d'effacer le rpertoire temporaire");
