#include <stdio.h>
#include "PersistentVals.h"
#include "../options.h"
#include "tonecurves.h"

/* Except for the first value below (initialized, which must be zero),
 * the initial values for many fields are actually obtained from the user's
 * initialization file options (mrwtoppmrc). See InitializePersistentVals
 * below.   When all initial values are set that way, these values will be
 * removed.
 */
PersistentVals plvals;

void
InitializePersistentVals (PersistentVals *pVals)
{
    double atof();

    /* Color balance controls. */
    pVals->newbal1 = FindBalanceIndex (balance1);
    if (pVals->newbal1 < 0)
        pVals->newbal1 = 0;
    pVals->newbal2 = FindBalanceIndex (balance2);
    if (pVals->newbal2 < 0)
        pVals->newbal2 = 0;
    pVals->mix = balanceMix;
    pVals->saturation = saturation;

    /* Exposure controls. */
    pVals->darkness = darkness;
    pVals->contrast = contrast;
    pVals->shadows = shadows;
    pVals->toneCurveNum = find_tone_curve (toneCurve);
    if (pVals->toneCurveNum < 0)
        pVals->toneCurveNum = 0;

    /* Filters. */
    pVals->applyVMF = applyVMF;
    pVals->applyMedianFilter = applyMedianFilter;
    pVals->radius = radius;
    pVals->blur = blur;
    pVals->iSharpen = iSharpen;
    pVals->cSharpen = cSharpen;
    pVals->filterColorOnly = filterColorOnly;

    /* Options. */
    pVals->finalShrink = shrink;
    pVals->previewShrink = previewShrink;
    pVals->iMethodNum = find_interpolation_method (imethod);
    if (pVals->iMethodNum < 0)
        pVals->iMethodNum = 0;

    /* Info. */
    pVals->fixShortSide = fixShortSide;
    pVals->fixedSideLength = fixedSideLength;

    /* Miscellaneous. */
    pVals->gammaVal = atof (gammaVal);
    pVals->vmedian_tolerance = vmedian_tolerance;
    pVals->histWidth = histWidth;
    pVals->histHeight = histHeight;

    /* No plans to let the user set the following initial values. */
    pVals->autolevel = 0;
    pVals->balanceMode = BALANCE_MODE_PRESET;
    pVals->userBalance.rgain = 256;
    pVals->userBalance.ggain = 256;
    pVals->userBalance.bgain = 256;
    pVals->rotate = 0;
    pVals->useLab = TRUE;

    pVals->initialized = 1;
}
