/*
 *   Written by Bradley Broom (2002).
 *
 *   Copyright (c) 2002 Bradley Broom
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdlib.h>
#include <stdio.h>

#include "MRW_Private.h"

char *progname;

void
Usage ()
{
	fprintf (stderr, "Usage: %s thumb < oldjpeg > newjpg\n", progname);
	exit (1);
}

/* Copies the embedded JPEG thumbnail from a Minolta Raw file to stdout.
 */

unsigned char thumb[2*1024*1024];

int
main (int argc, char *argv[])
{
	mrw_header	hdr;
	MinoltaJPG	jpg;
	char		*errmsg;
	FILE		*fd;
	int 		thumb_length, old_length;

	if ((fd = fopen (argv[1], "r")) == NULL) {
		fprintf (stderr, "Can't open %s\n", argv[1]);
		exit (1);
	}
	thumb_length = fread (thumb, 1, sizeof(thumb), fd);
	fclose (fd);
	fprintf (stderr, "Thumb length: %d\n", thumb_length);

	progname = argv[0];
	if (!LoadMinoltaJPG (stdin, &jpg)) {
	    fprintf (stderr, "%s: Unable to read JPG file:\n", progname);
	    fprintf (stderr, "    %s\n", errmsg);
	    Usage();
	}
	old_length = jpg.thumbnail_length;
	thumb[0] = jpg.thumbnail[0];
        IFD_SetUndefinedLength (jpg.manu_ifd, MANUTAG_THUMBNAIL, thumb_length);
	write (1, jpg.header, sizeof(jpg.header));
	write (1, jpg.data, jpg.data_length - old_length);
	write (1, thumb, thumb_length);

	exit (0);
}
