/*
 *   Written by Bradley Broom (2002).
 *
 *   Copyright (c) 2002 Bradley Broom
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <math.h>
#include <string.h>
#include "MRI.h"
#include "vmedian.h"

struct ReverserData {
	struct link *next;
	int	width;
	int	height;
};

static void
ReverserStart (void *private, int width, int height, int freedata)
{
	struct ReverserData *wd = private;

	wd->width = width;
	wd->height = height;
	(*wd->next->start) (wd->next->private, width, height, freedata);
}

static void
ReverserRow (void *private, void *data)
{
	struct ReverserData *wd = private;
	struct MRI_ScanLine *sl = data;
	unsigned short *R, *G, *B;
	int w2 = wd->width / 2;
	int x,x2;

	if (sl->scanLineType != LINETYPE_SHORT) {
		fprintf (stderr, "ReverserRow: Unexpected linetype %d\n", sl->scanLineType);
		exit (1);
	}
	R = (unsigned short *)sl->R;
	G = (unsigned short *)sl->G;
	B = (unsigned short *)sl->B;
	for (x = 0, x2 = wd->width-1; x < w2; x++, x2--) {
		int tr = R[x];
		int tg = G[x];
		int tb = B[x];
		unsigned long tmasks = sl->masks[x];
		R[x] = R[x2];
		R[x2] = tr;
		G[x] = G[x2];
		G[x2] = tg;
		B[x] = B[x2];
		B[x2] = tb;
		sl->masks[x] = sl->masks[x2];
		sl->masks[x2] = tmasks;
	}
	(*wd->next->row) (wd->next->private, sl);
}

static void
ReverserClose (void *private)
{
	struct ReverserData *wd = private;
	(*wd->next->close) (wd->next->private);
	free (wd->next);
	free (wd);
}

struct link *
MRI_GenReverser (struct link *next)
{
	struct ReverserData *wd = malloc (sizeof (struct ReverserData));
	struct link *ep = malloc (sizeof (*ep));
	if (wd == (struct ReverserData *)0 || ep == (struct link *)0) {
		fprintf (stderr, "Error: unable to allocate memory\n");
		exit (1);
	}
	ep->start = ReverserStart;
	ep->row = ReverserRow;
	ep->close = ReverserClose;
	ep->private = wd;
	wd->next = next;

	return ep;
}
