<?php
/**
 * $Id: chart.php,v 1.8 2003/03/26 08:31:28 courou Exp $
 *
 * Gnration d'un fichier SYLK  partir de donnes MySQL en vue d'une rcupration sous Excel.
 * L'avantange du format SYLK par rapport au format CSV est qu'il permet de dfinir des attributs
 * de mise en forme pour les donnes : alignement,gras, itallique, formats de donnes, ..
 * Auteur: J-Pierre DEZELUS
 * Email:  jpdezelus&#64;phpinfo.net
 * Web:    http://www.phpinfo.net/
 *
 * Date:  02/12/2001
 * Adaptation: Courou -- MyPhpMoney
 * Web:    http://allreponse.ath.cx
 * Email:  courou&#64;users.sourceforge.net
 *
 * Support    : http://sourceforge.net/projects/myphpmoney/
 * CVS        : http://cvs.sourceforge.net/cgi-bin/viewcvs.cgi/myphpmoney/
 */

/**
 * INCLUDE FILE
 */
     require_once 'config/settings.inc.php';

/**
 * ENTER IN THE SESSION OR BUILD THE LOGIN FORM
 */
     if (SQL_VerifSession()) {

/**
 * DEFINES VARIABLES FOR THE EXCEL FILE
 */
    define('__ALIGN_RIGHT__',                           'R'); ## ALIGN RIGHT
    define('__ALIGN_LEFT__',                            'L'); ## ALIGN LEFT
    define('__ALIGN_CENTER__',                          'C'); ## ALIGN CENTER
    define('__FORMAT_REEL__',                             1); ## #,##0.00
    define('__FORMAT_ENTIER__',                           2); ## #,##0
    define('__FORMAT_TEXTE__',                            3); ## @

    $DEFINE_SYLK_FORMATS[__FORMAT_REEL__]            = 'FF2'; ## FORMAT_REEL
    $DEFINE_SYLK_FORMATS[__FORMAT_ENTIER__]          = 'FF0'; ## FORMAT_ENTIER
    $DEFINE_SYLK_FORMATS[__FORMAT_TEXTE__]           = 'FG0'; ## FORMAT_TEXTE

    if (isset($_POST['choix_duree']) && $_POST['choix_duree'] != '') $choix_duree = $_POST['choix_duree'];
    if (isset($_POST['MT']) && $_POST['MT'] != '')                   $MT          = $_POST['MT'];
    if (isset($_POST['REMB']) && $_POST['REMB'] != '')               $REMB        = $_POST['REMB'];
    if (isset($_POST['duree']) && $_POST['duree'] != '')             $duree       = $_POST['duree'];
    if (isset($_POST['taux']) && $_POST['taux'] != '')               $taux        = $_POST['taux'];
    if ($choix_duree == 1) $nbr_page = $duree * 12;
    if ($choix_duree == 2) $nbr_page = $duree;

    $taux_mensuelle = $taux / 12;
    $MT             = str_replace(' ','',$MT);
    $REMB           = str_replace(' ','',$REMB);

/**
 *             CHAMPS            EN-TETE                        FORMAT                 ALIGN             WIDTH
 */
 $champs =
     array
     (
         array('i',               $_VAR['LANG_ACCOUNT_2'],      __FORMAT_ENTIER__,     __ALIGN_CENTER__,     5),
         array('time',            $_VAR['SIMUL_FORM_2'],        __FORMAT_TEXTE__,      __ALIGN_CENTER__,    10),
         array('DETTE',           $_VAR['SIMUL_FORM_3'],        __FORMAT_TEXTE__,      __ALIGN_CENTER__,    15),
         array('REMB',            $_VAR['SIMUL_FORM_4'],        __FORMAT_TEXTE__,      __ALIGN_CENTER__,    15),
         array('INTERET',         $_VAR['SIMUL_FORM_5'],        __FORMAT_TEXTE__,      __ALIGN_CENTER__,    15),
         array('CAPITAL',         $_VAR['SIMUL_FORM_6'],        __FORMAT_TEXTE__,      __ALIGN_CENTER__,    15),
         array('INTERETPLUS',     $_VAR['SIMUL_FORM_7'],        __FORMAT_TEXTE__,      __ALIGN_CENTER__,    20),
         array('MONTANT',         $_VAR['SIMUL_FORM_8'],        __FORMAT_TEXTE__,      __ALIGN_CENTER__,    15)
     );
/**
 *  EN-TETE HTTP
 */
     $tools->Construc_header('tableau.slk');

/**
 *  EN-TETE FILE
 */
        $excel_file  =  "ID;MYPHPMONEY\n";
        $excel_file .=  "\n";
/**
 *  FORMATS
 */
        $excel_file .=  "P;PGeneral\n";
        $excel_file .=  "P;P#,##0.00\n";       ## P;Pformat_1 (reels)
        $excel_file .=  "P;P#,##0\n";          ## P;Pformat_2 (entiers)
        $excel_file .=  "P;P@\n";              ## P;Pformat_3 (textes)
        $excel_file .=  "\n";
/**
 *  POLICE
 */
        $excel_file .=  "P;EArial;M200\n";
        $excel_file .=  "P;EArial;M200\n";
        $excel_file .=  "P;EArial;M200\n";
        $excel_file .=  "P;FArial;M200;SB\n";
        $excel_file .=  "\n";
/**
 *  NUMBER OF LIGNES  * NUMBERS OF COLUMN
 */
        $excel_file .=  "B;Y".($nbr_page-1);
        $excel_file .=  ";X".($nbcol = count($champs))."\n";
        $excel_file .=  "\n";
/**
 *  RECOVERY OF THE INFORMATION OF FORMATTING
 */
       for ($cpt = 0; $cpt < $nbcol; $cpt++) {
            $num_format[$cpt] = $champs[$cpt][2];
            $format[$cpt]     = $DEFINE_SYLK_FORMATS[ $num_format[$cpt] ] . $champs[$cpt][3];
        }
/**
 *  WIDTH OF THE COLUMNS
 */
        for ($cpt = 1; $cpt <= $nbcol; $cpt++) {
            $excel_file .=  "F;W".$cpt." ".$cpt." ".$champs[$cpt-1][4]."\n";
        }
        $excel_file .=  "F;W".$cpt." 256 8\n";
        $excel_file .=  "\n";
/**
 *  EN-TETE OF THE COLUMNS (BOLD --> SDM4)
 */
        for ($cpt = 1; $cpt <= $nbcol; $cpt++) {
            $excel_file .=  "F;SDM4;FG0C;".($cpt == 1 ? "Y1;" : "")."X".$cpt."\n";
            $excel_file .=  "C;N;K\"".$champs[$cpt-1][1]."\"\n";
        }
        $excel_file .=  "\n";
/**
 *  THE DATAS
 */
   $ligne = 2;
   $incomeplus = '';

    ## FOR FIX BUG THE MONTH (29,30,31)
    for ($i=1; $i <= $nbr_page; $i++) {
        $income       = round(((($i == 1 ? $MT : $MONTANT) * $taux_mensuelle) / 100),2);
        $CAPITAL      = $REMB - $income;
        $MONTANT      = ($i == 1 ? $MT : $MONTANT) - $CAPITAL;
        $incomeplus  += $income;

        $_month = (($_MPM['date_gettime']['mon']) + ($i - 1));
         $month = date('m',mktime(0,0,0,$_month));

          if ($_MPM['date_gettime']['mday'] <= 28) {
             $time = date('d-m-Y',mktime(0,0,0,$_month,$_MPM['date_gettime']['mday'],$_MPM['date_gettime']['year']));
          } else if (($_MPM['date_gettime']['mday'] > 28) && ($_MPM['date_gettime']['mday'] < 32)) {
             $der_j = $shuffle->getDaysInMonth($month,$_MPM['date_gettime']['year']);
                if ($der_j >= $_MPM['date_gettime']['mday']) {
                    $der_j = $_MPM['date_gettime']['mday'];
                } else {
                    $der_j = $der_j;
                }
             $time = date('d-m-Y',mktime(0,0,0,$_month,$der_j,$_MPM['date_gettime']['year']));
        }

        $enr[0] = $i;
        $enr[1] = $time;
        $enr[2] = $tools->formatage(($i == 1 ? $MT : $MONTANT));
        $enr[3] = $tools->formatage($REMB);
        $enr[4] = $tools->formatage($income);
        $enr[5] = $tools->formatage($CAPITAL);
        $enr[6] = $tools->formatage($incomeplus);
        $enr[7] = $tools->formatage($MONTANT);

        $j = $nbr_page - 1;
        if ($i == $nbr_page) $enr[7]= 0;
        if ($i == $j) $MONTANTs = $enr[7];
        if ($i== $nbr_page) { $enr[5]= $MONTANTs; $enr[3]= $MONTANTs + $enr[4];}
/**
 *  THE FIELDS
 */
        for ($cpt = 0; $cpt < $nbcol; $cpt++) {
/**
 *  FORMAT
 */
        $excel_file .=  "F;P".$num_format[$cpt].";".$format[$cpt];
        $excel_file .=  ($cpt == 0 ? ";Y".$ligne : "").";X".($cpt+1)."\n";
/**
 * VALUE
 */
        if ($num_format[$cpt] == __FORMAT_TEXTE__)
          $excel_file .=  "C;N;K\"".str_replace(';', ';;', $enr[$cpt])."\"\n"; ## ajout des ""
        else
          $excel_file .=  "C;N;K".$enr[$cpt]."\n";
        }
            $excel_file .=  "\n";
       $ligne++;
    } ## end of for $i <= $nbr_page

/**
 * END OF THE FILE
 */
          $excel_file .=  "E\n";
     echo $excel_file;
     page_close();
     } else {
          XHTML_DisplayLogin();
     XHTML_footer();
     } ## end if (SQL_VerifSession())