
function check(server,file_name,test_prompt)
{
  if (!server.enabled)
  {
    print_test_skipped(test_prompt)
  }
  else
  {
    var name_test_file=           "t\\" + file_name + ".test.connection.xml"
    var name_prepared_test_file=  "t\\" + file_name + ".test.prepared.connection.xml"
    var name_result_file=         "r\\" + file_name + ".result"
    var name_etalon_file=         "r\\" + file_name + ".result.etalon"
    var name_diff_file=           "r\\" + file_name + ".diff"

    server.prepare_connection_file(name_test_file,name_prepared_test_file)
    exec_to_file("Debug\\test_user_management.exe " + name_prepared_test_file, name_result_file)
    fso.GetFile(name_prepared_test_file).Delete()

    var fc_result= compare_results(name_etalon_file,name_result_file,name_diff_file)
    print_test_res(test_prompt,fc_result)
  }
}

print_title("test user management")

server_40.safe_start()
server_41.safe_start()
server_50.safe_start()

copy_dlls()

check(server_40,"mysql_40_simple", "simple test for mysql-4.0")
check(server_41,"mysql_41_simple", "simple test for mysql-4.1")
check(server_41,"mysql_50_simple", "simple test for mysql-5.0")

server_40.safe_stop()
server_41.safe_stop()
server_50.safe_stop()

clear_dlls()
print_footer()
