/* MAdministratorController */

#import <Cocoa/Cocoa.h>

#include "myx_public_interface.h"

@class MAdministrator;

// this does the role of a NSDocumentController
@interface MAdministratorController : NSObject
{
  IBOutlet id aboutPanel;
  IBOutlet id versionLabel;
  IBOutlet id recentMenu;
  
  id _prefPanel;
  NSMutableArray *_instances;
}

- (IBAction)showAbout:(id)sender;
- (IBAction)showPreferences:(id)sender;
- (IBAction)clearRecentMenu:(id)sender;

+ (MAdministratorController*)sharedDocumentController;

- (id)init;

- (void)newDocument: (id)sender;

- (void)addInstance: (MAdministrator*)instance;

- (void)removeInstance: (MAdministrator*)instance;

- (void)openInstanceWithConnectionName: (NSString*)connectionName;

- (void)noteNewRecentConnection: (MYX_USER_CONNECTION*)info;

@end
