#include <qmessagebox.h>
#include <qfiledialog.h>
#include <qfile.h>
#include <qheader.h>
#include <qpopupmenu.h>
#include <qmultilineedit.h>
#include <qstatusbar.h>
#include <qaccel.h>
#include <qcursor.h>
#include "mainwindow.h"
#include "querylistview.h"
#include "xchecklistitem.h"
#include "query.h"
#include "loglistviewitem.h"
#include "include/sql.h"

QueryListView::QueryListView(QMenuBar *menubar, QStatusBar *statusbar, MYSQL *mysql, struct __option__ *option, QWidget *parent)
	: QListView(parent)
{
	this->menubar = menubar;

	this->statusbar = statusbar;

	this->mysql = mysql;

	this->option = option;

	setAllColumnsShowFocus(TRUE);

	setSorting(-1);

	signal_connect();

	QAccel *s = new QAccel(this);
	s->connectItem(s->insertItem(Key_Delete), this, SLOT(slot_delete(int)));
}

QueryListView::~QueryListView()
{
}

void QueryListView::signal_connect()
{
	connect(this, SIGNAL(rightButtonClicked ( QListViewItem *, const QPoint &, int )), this, SLOT(slot_click(QListViewItem *, const QPoint &, int)));
	connect(header(), SIGNAL(clicked(int)), this, SLOT(slot_sort(int)));
}

void QueryListView::slot_click(QListViewItem *s, const QPoint &, int)
{
	if(is_select() == FALSE)
		return;
	
	hay = s;

	QPopupMenu *z = new QPopupMenu();

	if(s == NULL)
	{
		z->insertItem(tr("&Insert"), this, SLOT(slot_insert(int)));
		z->insertSeparator();
		z->insertItem(tr("R&eload"), this, SLOT(slot_reload()));
	}
	else
	{
		z->insertItem(tr("&Insert"), this, SLOT(slot_insert(int)));
		z->insertItem(tr("&Update"), this, SLOT(slot_update(int)));
		z->insertItem(tr("&Delete"), this, SLOT(slot_delete(int)));
		z->insertSeparator();
		z->insertItem(tr("Select &All"), this, SLOT(slot_select_all(int)));
		z->insertItem(tr("Select &None"), this, SLOT(slot_select_none(int)));
		z->insertSeparator();
		z->insertItem(tr("R&eload"), this, SLOT(slot_reload()));
	}		

	z->popup(QCursor::pos());
}

void QueryListView::set_sql(const QString &database, const QString &sql, const QString &)
{
	this->sql = sql;
	this->database = database;
	this->table = get_table();
}

int QueryListView::execute(bool)
{
	key.clear();
	type.clear();
	sort.clear();
	slot_clear();

	XCheckListItem *z;

    setRootIsDecorated(FALSE);
	
	if(database.length() != 0)
	{
		if(mysql_select_db(mysql,database.latin1()))
			return SQL_ERROR;
	}

	if(is_select())
		get_primary();

	if((SQL::sql_query(sql.latin1())))
	{
		if(statusbar)
			statusbar->message(QString::fromLocal8Bit(mysql_error(mysql)));
		return SQL_ERROR; 	 
	}

	result = mysql_store_result(mysql);
	
	if(result == NULL)
	{
		sql = sql.upper();

		if(sql.contains("CREATE") || sql.contains("DROP") || sql.contains("ALTER") || sql.contains("RENAME"))
			return SQL_SCHEMA;
		else if(sql.contains("UPDATE") || sql.contains("INSERT"))
			return SQL_UPDATE;
		else
			return SQL_NOSCHEMA;
	}

	while((this->field = mysql_fetch_field(result)))
	{
		type.insert(type.count(), this->field->type); 
		addColumn(this->field->name);

		if(key.find(QString(this->field->name).lower()) != key.end())
		{
			if(IS_NUM(this->field->type))
				key.replace(QString(this->field->name).lower(), FLAG_NUMBER);
			else
				key.replace(QString(this->field->name).lower(), FLAG_STRING);
		}

		sort.insert(sort.count(), FALSE);
	}

	XCheckListItem *a = NULL;

	while((row = mysql_fetch_row(result)))
	{
		unsigned long *size = mysql_fetch_lengths(result);

		char *value = new char[size[0] * 2 + 1];
		mysql_real_escape_string(mysql, value, row[0], size[0]);
		if(is_select())
			z = new XCheckListItem(this, QString::fromLocal8Bit(value), QCheckListItem::CheckBox);
		else
			z = new XCheckListItem(this, QString::fromLocal8Bit(value), QCheckListItem::Controller);
		delete []value;

		for(unsigned int s = 1; s < mysql_num_fields(result); s++)
		{
			char *value = new char[size[s] * 2 + 1];
			mysql_real_escape_string(mysql, value, row[s], size[s]);
			z->setText(s, QString::fromLocal8Bit(value));
			delete []value;
		}

		z->moveItem(a);

		a = z;
	}

	mysql_free_result(result);

	if(statusbar)
		statusbar->message(tr("Fields: ") + QString::number(columns()) + " , " + tr("Records: ") + QString::number(childCount()));

	return SQL_SIMPLE;
}

void QueryListView::slot_clear()
{
	int z;

	z = columns();

	for(int s = z - 1; s >=0; s--)
	{
		removeColumn(s);
	}

	clear();
}

void QueryListView::slot_save()
{
	QString name = QFileDialog::getSaveFileName("", "*.csv", this);
	if(name.isEmpty()) 
	{
		return;
    } 

	if(QFile::exists(name))
	{
		int z = QMessageBox::warning (this, tr("MySQL Navigator"), tr("File already exists.\nDo you want to overwrite it?"), tr("Yes"), tr("No"));
		
		if(z == 1)
		{
			return;
		}
	}

	QString buffer;

	QFile sql(name);

	if(sql.open(IO_WriteOnly) == FALSE)
	{
		//debug("open failed");
		return;
	}

	/*
	//buffer += "# Query result\n";
	buffer += "# Database: ";
	buffer += this->database;
	buffer += "\n";
	buffer += "# Query: ";
	buffer += this->sql;
	buffer += "\n";
	buffer += "# Field: ";
	*/

	int column = columns();

	/*
	for(int s = 0; s < column; s++)
	{
		buffer += header()->label(s);
		if(s != column - 1)
				buffer += ((MainWindow *)qApp->mainWidget())->option.separator1;
	}
	buffer += "\n";
	*/

	QListViewItemIterator z(this);

	for(; z.current(); ++z)
	{
		for(int s = 0; s < column; s++)
		{
			char *value;
			value = new char[z.current()->text(s).local8Bit().length() * 2 + 1];
			mysql_real_escape_string(mysql, value, z.current()->text(s).local8Bit(), z.current()->text(s).local8Bit().length());
			if(strlen(value))
				buffer += QString(value);
			else
				buffer += "";
			delete []value;
			
			if(s != column - 1)
				buffer += ',';
		}
		buffer += "\n";
	}

	//debug(buffer.latin1());

	sql.writeBlock(buffer.latin1(), buffer.length());

	sql.close();

	//QMessageBox::information(this, tr("MySQL Navigator"), tr("Query results are successfully saved to ") + name);
}

void QueryListView::slot_close()
{
	parentWidget()->close();
}

void QueryListView::slot_about()
{
	QMessageBox::information(this, tr("MySQL Navigator"), tr("This is Query"));
}

void QueryListView::slot_sort(int s)
{
	QList<QListViewItem> value;	

	if(sort.find(s).data() == FALSE)
	{
		 QListViewItemIterator z(this);
		 for ( ; z.current(); ++z) 
		 {
			 if(value.count() == 0)
			 {
				 value.append(z.current());
				 continue;
			 }

			bool z_ = FALSE;

			for(unsigned int s_ = 0; s_ < value.count(); s_++)
			{
				if(IS_NUM(type[s]))
				{
					if(z.current()->text(s).toFloat() < value.at(s_)->text(s).toFloat())
					{
						value.insert(s_, z.current());
						z_ = TRUE;
						break;
					}
				}
				else
				{
					if(z.current()->text(s) < value.at(s_)->text(s))
					{
						value.insert(s_, z.current());
						z_ = TRUE;
						break;
					}
				}
			}

			if(z_ == FALSE)
				value.append(z.current());
		 }

		sort.replace(s, TRUE);
	}
	else
	{
		 QListViewItemIterator z(this);
		 for ( ; z.current(); ++z) 
		 {
			if(value.count() == 0)
			 {
				 value.append(z.current());
				 continue;
			 }

			bool z_ = FALSE;

			for(unsigned int s_ = 0; s_ < value.count(); s_++)
			{
				if(IS_NUM(type[s]))
				{
					if(z.current()->text(s).toFloat() > value.at(s_)->text(s).toFloat())
					{
						value.insert(s_, z.current());
						z_ = TRUE;
						break;
					}
				}
				else
				{
					if(z.current()->text(s) > value.at(s_)->text(s))
					{
						value.insert(s_, z.current());
						z_ = TRUE;
						break;
					}
				}
			}

			if(z_ == FALSE)
				value.append(z.current());
		 }
	
		 sort.replace(s, FALSE);
	}

	XCheckListItem *s_ = NULL;
	XCheckListItem *z = NULL;
	XCheckListItem *a = NULL;
	
	while((s_ = (XCheckListItem *)value.getFirst()))
	{
		if(is_select())
			z = new XCheckListItem(this, s_->text(0), QCheckListItem::CheckBox);
		else
			z = new XCheckListItem(this, s_->text(0), QCheckListItem::Controller);

		for(unsigned int s = 1; s < type.count(); s++)
		{
			z->setText(s, s_->text(s));
		}

		z->moveItem(a);

		a = z;

		value.removeFirst ();
		delete s_;
	}
}

QListViewItem *QueryListView::get_last()
{
	QListViewItem *s;
	QListViewItem *last;

	s = firstChild();

	if(s == NULL)
	{
		return NULL;
	}

	last = s;
	
	while(TRUE)
	{
		s = s->itemBelow();

		if(s == NULL)
		{
			break;
		}

		last = s;
	}

	return last;
}

void QueryListView::slot_insert(int)
{
	if(is_select() == FALSE)
		return;

	QString sql;

	sql += "INSERT INTO ";
	sql += table;
	sql += "\n";
	sql += "(";

	unsigned int s;

	for(s = 0; s < type.count(); s++)
	{
		sql += "\n";

		sql += header()->label(s);

		if(s != type.count() - 1)
			sql += ", ";
	}

	sql += "\n";
	sql += ")";
	sql += "\n";
	sql += "VALUES";
	sql += "\n";
	sql += "(";

	for(s = 0; s < type.count(); s++)
	{
		sql += "\n";
		
		if(IS_NUM(type[s]))
			sql += "";
		else
		{
			sql += "\"";
			sql += "";
			sql += "\"";
		}

		if(s != type.count() - 1)
			sql += ", ";
	}

	sql += "\n";
	sql += ")";

	emit signal_query(sql, database);
}

void QueryListView::slot_update(int)
{
	if(is_select() == FALSE)
		return;

	if(key.count() == FALSE)
	{
		QMessageBox::warning(this, tr("MySQL Navigator"), QString("Table ") + table + " doesn't have primary key.\nYou must manually delete or update any record.");
		return;
	}

	if(can_modify() == FALSE)
	{
		QMessageBox::warning(this, tr("MySQL Navigator"), "To update or delete any record,\nyou must select all primary key fields.");
		return;
	}
	
	hay = selectedItem();

	if(hay == NULL)
		return;

	QString sql;

	sql += "UPDATE ";
	sql += table;
	sql += " SET ";

	unsigned int s;

	for(s = 0; s < type.count(); s++)
	{
		sql += "\n";

		sql += header()->label(s);
		sql += " = ";

		if(IS_NUM(type[s]))
		{
		}
		else
		{
			sql += "\"";
			sql += "";	
			sql += "\"";
		}

		if(s != type.count() - 1)
			sql += ", ";
	}

	sql += "\n";

	sql += "WHERE \n";
	
	for(s = 0; s < type.count(); s++)
	{
		if(key.find(header()->label(s).lower()) != key.end())
		{
			if(IS_NUM(type[s]))
			{
				sql += header()->label(s);
				sql += " = ";
				sql += hay->text(s);
					
				if(s != type.count() - 1)
					sql += " && ";
			}
			else
			{
				sql += header()->label(s);
				sql += " = ";
				sql += "\"";	
				sql += hay->text(s).local8Bit();
				sql += "\"";	
					
				if(s != type.count() - 1)
					sql += " && ";
			}
		}
	}

	sql = sql.stripWhiteSpace();

	if(sql.right(2) == "&&")
		sql = sql.left(sql.length() - 2);

	emit signal_query(sql, database);
}

void QueryListView::slot_delete(int)
{
	if(is_select() == FALSE)
		return;

	if(key.count() == FALSE)
	{
		QMessageBox::warning(this, tr("MySQL Navigator"), QString("Table ") + table + " doesn't have primary key.\nYou must manually delete or update any record.");
		return;
	}

	if(can_modify() == FALSE)
	{
		QMessageBox::warning(this, tr("MySQL Navigator"), "To update or delete any record,\nyou must select all primary key fields.");
		return;
	}

	int s = QMessageBox::warning (this, tr("MySQL Navigator"), tr("Do you want to delete selected records ?"), tr("Yes"), tr("No"));

	if(s == 1)
	{
		return;
	}

	if(mysql_select_db(mysql, database.latin1()))
		return;

	QListViewItemIterator z(this);

	for(; z.current(); z++)
	{
		if(((QCheckListItem *)z.current())->isOn())
		{
			QString sql;

			if(table.isEmpty())
				return;

			sql += "DELETE FROM ";
			sql += table;
			sql += " WHERE ";

			unsigned int s;

			for(s = 0; s < type.count(); s++)
			{
				if(key.find(header()->label(s).lower()) != key.end())
				{
					if(IS_NUM(type[s]))
					{
						sql += header()->label(s);
						sql += " = ";
						sql += z.current()->text(s);
					
						if(s != type.count() - 1)
							sql += " && ";
					}
					else
					{
						sql += header()->label(s);
						sql += " = ";
						sql += "\"";	
						sql += z.current()->text(s).local8Bit();
						sql += "\"";	
					
						if(s != type.count() - 1)
							sql += " && ";
					}
				}
			}

			sql = sql.stripWhiteSpace();

			if(sql.right(2) == "&&")
				sql = sql.left(sql.length() - 2);
	
			//QMessageBox::critical(this, 0, sql);

			if(SQL::sql_query(sql.latin1()))
			{
				QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(mysql)));
				return;
			}
		}
	}

	execute();
}

QString QueryListView::get_table()
{
	bool flag = FALSE;

	QString table;

	QString query = this->sql;

	query = query.simplifyWhiteSpace();
	if(query.at(query.length() - 1) == ';')
		query = query.left(query.length() - 1);	

	for(unsigned int s = 0; s < query.length(); s++)
	{
		if(flag)
		{
			table += QChar(query.at(s));
		}

		if((query.at(s) == 'F' || query.at(s) == 'f') && (query.at(s + 1) == 'R' || query.at(s + 1) == 'r') && (query.at(s + 2) == 'O' || query.at(s + 2) == 'o') && (query.at(s + 3) == 'M' || query.at(s + 3) == 'm'))
		{
			s += 4;
			flag = TRUE;
			continue;
		}

		if(flag)
			if(query.at(s) == ' ')
			{
				flag = FALSE;
				break;
			}

	}

	//debug("table: %s", table.latin1());

	return table.stripWhiteSpace();
}

bool QueryListView::is_select()
{
	QString s = this->sql;

	s = s.lower();
	
	s = s.stripWhiteSpace();

	if(s.left(6) == "select")
			return TRUE;
	else
		return FALSE;
}

void QueryListView::slot_sql_success()
{
	execute();
}

void QueryListView::slot_reload()
{
	execute();
}

void QueryListView::slot_option()
{
}

void QueryListView::slot_select_all(int)
{
	QListViewItemIterator z(this);

	for(; z.current(); z++)
	{
		((QCheckListItem *)z.current())->setOn(TRUE);
	}
}

void QueryListView::slot_select_none(int)
{
	QListViewItemIterator z(this);

	for(; z.current(); z++)
	{
		((QCheckListItem *)z.current())->setOn(FALSE);
	}
}

bool
QueryListView::get_primary()
{
	MYSQL_RES *result;

	QString sql = "show keys from " + table;

	if(SQL::sql_query(sql.latin1()))
	{
	}
	else
	{
		result = mysql_store_result(mysql);

		if(result == NULL)
			return FALSE;

		while(MYSQL_ROW row = mysql_fetch_row(result))
		{
			if(QString(row[2]) == "PRIMARY")
			{
				key.insert(QString(row[4]).lower(), FLAG_NONE);
			}
		}
		mysql_free_result(result);
	}
	
	if(key.count() == 0)
		return FALSE;

	return TRUE;
}

bool 
QueryListView::can_modify()
{
	QMap<QString, int>::Iterator z;
	for(z = key.begin(); z != key.end(); z++)
	{	
		if(z.data() == FLAG_NONE)
		{
			return FALSE;
		}
	}

	if(childCount() == 0)
		return FALSE;

	return TRUE;
}
