/* Copyright (C) 2004 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */


#include "myx_grt_private.h"


/*
 *---------------------------------------------------------------------------
 * myx_grt_get_loader_of_type -- return the loader struct for the required type
 *
 * ARGUMENTS
 *   grt - the GRT environment
 *   type - type of module loader to look up
 *
 * DESCRIPTION
 *
 * RETURN VALUE
 *    NULL if error, the loader if it's found.
 *---------------------------------------------------------------------------
 */
MYX_GRT_MODULE_LOADER *myx_grt_get_loader_of_type(MYX_GRT *grt, MYX_GRT_MODULE_TYPE type)
{
  unsigned int i;
  for (i= 0; i < grt->loaders_num; i++)
  {
    if (grt->loaders[i]->loader_type == type)
      return grt->loaders[i];
  }
  return NULL;
}


/*
 *---------------------------------------------------------------------------
 * myx_grt_add_module -- adds a module to the list of modules of the GRT
 *
 * ARGUMENTS
 *  grt - grt to add module
 *  module - module to add. Must not be freed
 *
 * DESCRIPTION
 *  
 * RETURN VALUE
 *  MYX_GRT_NO_ERROR
 *---------------------------------------------------------------------------
 */
MYX_GRT_ERROR myx_grt_add_module(MYX_GRT *grt, MYX_GRT_MODULE *module)
{
  grt->modules= g_realloc(grt->modules, sizeof(MYX_GRT_MODULE*)*(grt->modules_num+1));
  grt->modules[grt->modules_num++]= module;

  return MYX_GRT_NO_ERROR;
}



void myx_grt_parse_function_spec(const char *spec, MYX_GRT_FUNCTION *func)
{
  char *tmp= g_strdup(spec);

  func->name= g_strdup(strtok(tmp, ":"));
  func->param_struct_name= g_strdup(strtok(NULL, ":"));
  func->return_struct_name= g_strdup(strtok(NULL, ":"));

  g_free(tmp);
}

