/* THE NEMESIS PROJECT
 * Copyright (C) 2001 - 2003 Jeff Nathan <jeff@snort.org>
 *
 * nemesis.h
 *
 */

#ifndef __NEMESIS_H__
#define __NEMESIS_H__

#if defined(HAVE_CONFIG_H)
    #include "config.h"
#endif

#include <libnet.h>

#define BUILD 22
#define PAYLOADMODE 0
#define OPTIONSMODE 1
#define OPTIONSBUFFSIZE 40

#ifndef IPTOS_LOWDELAY
#define IPTOS_LOWDELAY 0x10
#endif
#ifndef IPTOS_THROUGHPUT
#define IPTOS_THROUGHPUT 0x08
#endif
#ifndef IPTOS_RELIABILITY
#define IPTOS_RELIABILITY 0x04
#endif
#ifndef IPTOS_LOWCOST
#define IPTOS_LOWCOST 0x02
#endif
#ifndef TH_ECE
#define TH_ECE 0x40
#endif
#ifndef TH_CWR
#define TH_CWR 0x80
#endif

#define ARPBUFFSIZE 1472
#define DNSTCP_RAWBUFFSIZE 65403    /* plan for IP and TCP options */
#define DNSTCP_LINKBUFFSIZE 1368    /* link-layer version of above */
#define DNSUDP_RAWBUFFSIZE 65455    /* plan for IP options */
#define DNSUDP_LINKBUFFSIZE 1420    /* link-layer version of above */
#define ETHERBUFFSIZE 1500          /* max frame size */
#define ICMP_RAWBUFFSIZE 65387      /* plan for IP options & max ICMP header 
                                       len */
#define ICMP_LINKBUFFSIZE 1352      /* link-layer version of above */
#define IGMP_RAWBUFFSIZE 65467      /* plan for IP options */
#define IGMP_LINKBUFFSIZE 1432      /* link-layer version of above */
#define IP_RAWBUFFSIZE 65475        /* plan for IP options */
#define IP_LINKBUFFSIZE 1440        /* link-layer version of above */
#define RIP_RAWBUFFSIZE 65393       /* plan for IP options & max RIP header 
                                       len */
#define RIP_LINKBUFFSIZE 1358       /* link-layer version of above */
#define TCP_RAWBUFFSIZE 65415       /* plan for IP and TCP options */
#define TCP_LINKBUFFSIZE 1380       /* link-layer version of above */
#define UDP_RAWBUFFSIZE 65467       /* plan for IP options */
#define UDP_LINKBUFFSIZE 1432       /* link-layer version of above */

#define FP_MAX_ARGS 4           /* number of IP fragment parsing tokens */

typedef struct libnet_arp_hdr ARPhdr;
typedef struct libnet_as_lsa_hdr ASLSAhdr;
typedef struct libnet_auth_hdr AUTHhdr;
typedef struct libnet_dbd_hdr DBDhdr;
typedef struct libnet_dns_hdr DNShdr;
typedef struct libnet_ethernet_hdr ETHERhdr;
typedef struct libnet_icmp_hdr ICMPhdr;
typedef struct libnet_igmp_hdr IGMPhdr;
typedef struct libnet_ip_hdr IPhdr;
typedef struct libnet_lsa_hdr LSAhdr;
typedef struct libnet_lsr_hdr LSRhdr;
typedef struct libnet_lsu_hdr LSUhdr;
typedef struct libnet_ospf_hdr OSPFhdr;
typedef struct libnet_ospf_hello_hdr OSPFHELLOhdr;
typedef struct libnet_net_lsa_hdr NETLSAhdr;
typedef struct libnet_rip_hdr RIPhdr;
typedef struct libnet_rtr_lsa_hdr RTRLSAhdr;
typedef struct libnet_sum_lsa_hdr SUMLSAhdr;
typedef struct libnet_tcp_hdr TCPhdr;
typedef struct libnet_udp_hdr UDPhdr;
typedef struct libnet_vrrp_hdr VRRPhdr;

extern char zero[6];
extern char one[6];
extern char title[81];
extern char errbuf[256];
extern char *pcap_outfile;
extern char *validtcpflags;
extern const char *version;
extern int verbose;
extern int got_link;
extern int got_ipoptions;
extern int got_tcpoptions;

typedef struct _PayloadData
{
    int32_t payload_s;      /* payload size */
    u_int8_t *payload;      /* pointer to payload memory */
} PayloadData;

typedef struct _OptionsData
{
    int32_t options_s;      /* options size */
    u_int8_t *options;      /* pointer to options memory */
} OptionsData;

/* support functions */
u_int32_t xgetint32(const char *);
u_int16_t xgetint16(const char *);
u_int8_t xgetint8(const char *);
int gmt2local(time_t);
void hexdump(char *, u_int32_t);
int nemesis_name_resolve(char *, u_int32_t *);
int nemesis_check_link(ETHERhdr *, char *);
char *nemesis_lookup_linktype(int);
int nemesis_seedrand(void);
int parsefrag(IPhdr *, char *);
int readfile(u_int8_t *, char *, u_int32_t, u_int32_t);

#if defined(WIN32) || !defined(HAVE_INET_ATON)
    int inet_aton(const char *, struct in_addr *);
#endif
#if defined(WIN32) || !defined(HAVE_GETOPT)
    int getopt(int, char * const *argv, const char *);
#endif
#if defined(WIN32) || !defined(HAVE_STRSEP)
    char *strsep(char **, const char *);
#endif

void maketitle(char *, const char *, const char *);
void nemesis_usage(char *);
#if defined(WIN32)
    void PrintDeviceList(const char *);
    void *GetAdapterFromList(void *, int);
    int getdev(int, char **);
#endif

/* printout functions */
void printethernet(ETHERhdr);
void printarp(ARPhdr, int);
void printip(IPhdr);
void printtcp(TCPhdr);
void printudp(UDPhdr);
void printicmp(ICMPhdr, int);
void printrip(RIPhdr);

/* injection functions */
void nemesis_arp(int, char **);
void nemesis_dns(int, char **);
void nemesis_ethernet(int, char **);
void nemesis_icmp(int, char **);
void nemesis_igmp(int, char **);
void nemesis_ip(int, char **);
void nemesis_ospf(int, char **);
void nemesis_rip(int, char **);
void nemesis_tcp(int, char **);
void nemesis_udp(int, char **);

#endif /* __NEMESIS_H__ */
