/* This file is part of Netwib.
*/

/*-------------------------------------------------------------*/
netwib_err netwib_priv_rand_seed(netwib_uint64 *pseed)
{

#if defined NETWIBDEF_SYSNAME_Unix
  {
    int fd, reti;
    char arr[8];
    netwib_err ret;

    /* try with "/dev/random" */
    fd = open("/dev/random", O_RDONLY);
    if (fd != -1) {
      ret = netwib_priv_fd_block_set(fd, NETWIB_FALSE);
      if (ret == NETWIB_ERR_OK) {
        reti = read(fd, arr, 8);
        if (reti == 8) {
          netwib_c2_uint64_set_8(*pseed, arr[0], arr[1], arr[2], arr[3],
                                 arr[4], arr[5], arr[6], arr[7]);
          close(fd);
          errno = 0;
          return(NETWIB_ERR_OK);
        }
      }
      close(fd);
    }

    /* try with "/dev/urandom" */
    fd = open("/dev/urandom", O_RDONLY);
    if (fd != -1) {
      ret = netwib_priv_fd_block_set(fd, NETWIB_FALSE);
      if (ret == NETWIB_ERR_OK) {
        reti = read(fd, arr, 8);
        if (reti == 8) {
          netwib_c2_uint64_set_8(*pseed, arr[0], arr[1], arr[2], arr[3],
                                 arr[4], arr[5], arr[6], arr[7]);
          close(fd);
          errno = 0;
          return(NETWIB_ERR_OK);
        }
      }
      close(fd);
    }

    /* use time and pid */
    netwib_c2_uint64_set_32(*pseed, time(0), (getpid() << 16) | getppid());
  }
#elif defined NETWIBDEF_SYSNAME_Windows
  {
    struct _timeb tstruct;

    /* use localtime */
    _ftime(&tstruct);
    netwib_c2_uint64_set_32(*pseed, tstruct.time, tstruct.millitm);
  }
#else
#error "Unknown value for NETWIBDEF_SYSNAME"
#endif

  errno = 0;
  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwib_priv_rand_gene(netwib_uint32 *prand32,
                                 netwib_data randarray)
{
  netwib_priv_glovars_t *ptr = &netwib_priv_glovars;

  netwib_er(netwib_priv_glovars_wrlock());

#if NETWIB_INT64_FAKE == 0
  ptr->rand_seed = NETWIB_UINT_LL(0x5851F42D4C957F2D) * ptr->rand_seed + 1;
#else
  {
    netwib_uint64 a, b;
    a.high = 0x5851F42D;
    a.low = 0x4C957F2D;
    netwib_er(netwib_uint64_mul(a, ptr->rand_seed, &b));
    netwib_er(netwib_uint64_inc(&b));
    ptr->rand_seed = b;
  }
#endif

  if (prand32 != NULL) {
    *prand32 = netwib_c2_uint64_32high(ptr->rand_seed);
  }

  if (randarray != NULL) {
#if NETWIB_INT64_FAKE == 0
    randarray[0] = netwib_c2_uint64_0(ptr->rand_seed);
    randarray[1] = netwib_c2_uint64_1(ptr->rand_seed);
    randarray[2] = netwib_c2_uint64_2(ptr->rand_seed);
    randarray[3] = netwib_c2_uint64_3(ptr->rand_seed);
    randarray[4] = netwib_c2_uint64_4(ptr->rand_seed);
    randarray[5] = netwib_c2_uint64_5(ptr->rand_seed);
#else
    randarray[0] = netwib_c2_uint32_0(ptr->rand_seed.high);
    randarray[1] = netwib_c2_uint32_1(ptr->rand_seed.high);
    randarray[2] = netwib_c2_uint32_2(ptr->rand_seed.high);
    randarray[3] = netwib_c2_uint32_3(ptr->rand_seed.high);
    randarray[4] = netwib_c2_uint32_0(ptr->rand_seed.low);
    randarray[5] = netwib_c2_uint32_1(ptr->rand_seed.low);
#endif
  }

  netwib_er(netwib_priv_glovars_wrunlock());

  return(NETWIB_ERR_OK);
}
