#include "netwibtest.h"

/*-------------------------------------------------------------*/
static netwib_err netwib_buf_decode_test(void)
{
  netwib_buf buf, buf2;

  puts("++++----\nTest of netwib_buf_decode");

  /**/
  netwib_er(netwib_buf_decode(NULL, NETWIB_DECODETYPE_HEXA, NULL));

  netwib_er(netwib_buf_init_ext_text("41 4d 4E", &buf2));
  netwib_er(netwib_buf_decode(&buf2, NETWIB_DECODETYPE_HEXA, NULL));

  netwib_er(netwib_buf_init_mallocdefault(&buf));
  netwib_er(netwib_buf_init_ext_text("", &buf2));
  netwib_er(netwib_buf_decode(&buf2, NETWIB_DECODETYPE_HEXA, &buf));
  netwib_er(netwibtest_buf_content2(&buf, ""));
  netwib_er(netwib_buf_close(&buf));

  netwib_er(netwib_buf_init_mallocdefault(&buf));
  netwib_er(netwib_buf_init_ext_text("41 4 2 4\t3\r\n", &buf2));
  netwib_er(netwib_buf_decode(&buf2, NETWIB_DECODETYPE_HEXA, &buf));
  netwib_er(netwibtest_buf_content2(&buf, "ABC"));
  netwib_er(netwib_buf_close(&buf));

  netwib_er(netwib_buf_init_mallocdefault(&buf));
  netwib_er(netwib_buf_init_ext_text("4 ", &buf2));
  netwib_eir(netwib_buf_decode(&buf2, NETWIB_DECODETYPE_HEXA, &buf),
             NETWIB_ERR_PAHEXAODD);
  netwib_er(netwibtest_buf_content2(&buf, ""));
  netwib_er(netwib_buf_close(&buf));

  netwib_er(netwib_buf_init_mallocdefault(&buf));
  netwib_er(netwib_buf_init_ext_text("4M", &buf2));
  netwib_eir(netwib_buf_decode(&buf2, NETWIB_DECODETYPE_HEXA, &buf),
             NETWIB_ERR_PAHEXACHAR);
  netwib_er(netwibtest_buf_content2(&buf, ""));
  netwib_er(netwib_buf_close(&buf));

  netwib_er(netwib_buf_init_mallocdefault(&buf));
  netwib_er(netwib_buf_init_ext_text("41 4d 4E", &buf2));
  netwib_er(netwib_buf_decode(&buf2, NETWIB_DECODETYPE_HEXA, &buf));
  netwib_er(netwibtest_buf_content2(&buf, "AMN"));
  netwib_er(netwib_buf_close(&buf));

  /**/
  netwib_er(netwib_buf_decode(NULL, NETWIB_DECODETYPE_MIXED, NULL));

  netwib_er(netwib_buf_init_ext_text("41 4d 4E", &buf2));
  netwib_er(netwib_buf_decode(&buf2, NETWIB_DECODETYPE_MIXED, NULL));

  netwib_er(netwib_buf_init_mallocdefault(&buf));
  netwib_er(netwib_buf_init_ext_text("", &buf2));
  netwib_er(netwib_buf_decode(&buf2, NETWIB_DECODETYPE_MIXED, &buf));
  netwib_er(netwibtest_buf_content2(&buf, ""));
  netwib_er(netwib_buf_close(&buf));

  netwib_er(netwib_buf_init_mallocdefault(&buf));
  netwib_er(netwib_buf_init_ext_text("41 4 2 4\t3\r\n", &buf2));
  netwib_er(netwib_buf_decode(&buf2, NETWIB_DECODETYPE_MIXED, &buf));
  netwib_er(netwibtest_buf_content2(&buf, "ABC"));
  netwib_er(netwib_buf_close(&buf));

  netwib_er(netwib_buf_init_mallocdefault(&buf));
  netwib_er(netwib_buf_init_ext_text("4 ", &buf2));
  netwib_eir(netwib_buf_decode(&buf2, NETWIB_DECODETYPE_MIXED, &buf),
             NETWIB_ERR_PAHEXAODD);
  netwib_er(netwibtest_buf_content2(&buf, ""));
  netwib_er(netwib_buf_close(&buf));

  netwib_er(netwib_buf_init_mallocdefault(&buf));
  netwib_er(netwib_buf_init_ext_text("4M", &buf2));
  netwib_eir(netwib_buf_decode(&buf2, NETWIB_DECODETYPE_MIXED, &buf),
             NETWIB_ERR_PAHEXACHAR);
  netwib_er(netwibtest_buf_content2(&buf, ""));
  netwib_er(netwib_buf_close(&buf));

  netwib_er(netwib_buf_init_mallocdefault(&buf));
  netwib_er(netwib_buf_init_ext_text("41 4d 4E", &buf2));
  netwib_er(netwib_buf_decode(&buf2, NETWIB_DECODETYPE_MIXED, &buf));
  netwib_er(netwibtest_buf_content2(&buf, "AMN"));
  netwib_er(netwib_buf_close(&buf));

  netwib_er(netwib_buf_init_mallocdefault(&buf));
  netwib_er(netwib_buf_init_ext_text("41 4d 4E 'a'", &buf2));
  netwib_er(netwib_buf_decode(&buf2, NETWIB_DECODETYPE_MIXED, &buf));
  netwib_er(netwibtest_buf_content2(&buf, "AMNa"));
  netwib_er(netwib_buf_close(&buf));

  netwib_er(netwib_buf_init_mallocdefault(&buf));
  netwib_er(netwib_buf_init_ext_text("41 4d 4E 'a'' b' 'e' '' 61 'r'",
                                     &buf2));
  netwib_er(netwib_buf_decode(&buf2, NETWIB_DECODETYPE_MIXED, &buf));
  netwib_er(netwibtest_buf_content2(&buf, "AMNa' bear"));
  netwib_er(netwib_buf_close(&buf));

  netwib_er(netwib_buf_init_mallocdefault(&buf));
  netwib_er(netwib_buf_init_ext_text("'a'' b' 'e' '' 61 'r'",
                                     &buf2));
  netwib_er(netwib_buf_decode(&buf2, NETWIB_DECODETYPE_MIXED, &buf));
  netwib_er(netwibtest_buf_content2(&buf, "a' bear"));
  netwib_er(netwib_buf_close(&buf));

  netwib_er(netwib_buf_init_mallocdefault(&buf));
  netwib_er(netwib_buf_init_ext_text("4 'e' 5", &buf2));
  netwib_eir(netwib_buf_decode(&buf2, NETWIB_DECODETYPE_MIXED, &buf),
             NETWIB_ERR_PAHEXAODD);
  netwib_er(netwibtest_buf_content2(&buf, ""));
  netwib_er(netwib_buf_close(&buf));

  netwib_er(netwib_buf_init_mallocdefault(&buf));
  netwib_er(netwib_buf_init_ext_text("44 'e   ", &buf2));
  netwib_eir(netwib_buf_decode(&buf2, NETWIB_DECODETYPE_MIXED, &buf),
             NETWIB_ERR_PAMIXED);
  netwib_er(netwibtest_buf_content2(&buf, ""));
  netwib_er(netwib_buf_close(&buf));

  netwib_er(netwib_buf_init_mallocdefault(&buf));
  netwib_er(netwib_buf_init_ext_text("'a''''b '' '''",
                                     &buf2));
  netwib_er(netwib_buf_decode(&buf2, NETWIB_DECODETYPE_MIXED, &buf));
  netwib_er(netwibtest_buf_content2(&buf, "a''b ' '"));
  netwib_er(netwib_buf_close(&buf));

  /**/
  netwib_er(netwib_buf_decode(NULL, NETWIB_DECODETYPE_BASE64, NULL));

  netwib_er(netwib_buf_init_ext_text("YQ==", &buf2));
  netwib_er(netwib_buf_decode(&buf2, NETWIB_DECODETYPE_BASE64, NULL));

  netwib_er(netwib_buf_init_mallocdefault(&buf));
  netwib_er(netwib_buf_init_ext_text("", &buf2));
  netwib_er(netwib_buf_decode(&buf2, NETWIB_DECODETYPE_BASE64, &buf));
  netwib_er(netwibtest_buf_content2(&buf, ""));
  netwib_er(netwib_buf_close(&buf));

  netwib_er(netwib_buf_init_mallocdefault(&buf));
  netwib_er(netwib_buf_init_ext_text("YQ==", &buf2));
  netwib_er(netwib_buf_decode(&buf2, NETWIB_DECODETYPE_BASE64, &buf));
  netwib_er(netwibtest_buf_content2(&buf, "a"));
  netwib_er(netwib_buf_close(&buf));
  netwib_er(netwib_buf_init_mallocdefault(&buf));
  netwib_er(netwib_buf_init_ext_text("YWI=", &buf2));
  netwib_er(netwib_buf_decode(&buf2, NETWIB_DECODETYPE_BASE64, &buf));
  netwib_er(netwibtest_buf_content2(&buf, "ab"));
  netwib_er(netwib_buf_close(&buf));
  netwib_er(netwib_buf_init_mallocdefault(&buf));
  netwib_er(netwib_buf_init_ext_text("YWJj", &buf2));
  netwib_er(netwib_buf_decode(&buf2, NETWIB_DECODETYPE_BASE64, &buf));
  netwib_er(netwibtest_buf_content2(&buf, "abc"));
  netwib_er(netwib_buf_close(&buf));
  netwib_er(netwib_buf_init_mallocdefault(&buf));
  netwib_er(netwib_buf_init_ext_text("YWJjZA==", &buf2));
  netwib_er(netwib_buf_decode(&buf2, NETWIB_DECODETYPE_BASE64, &buf));
  netwib_er(netwibtest_buf_content2(&buf, "abcd"));
  netwib_er(netwib_buf_close(&buf));

  netwib_er(netwib_buf_init_mallocdefault(&buf));
  netwib_er(netwib_buf_init_ext_text("4", &buf2));
  netwib_eir(netwib_buf_decode(&buf2, NETWIB_DECODETYPE_BASE64, &buf),
             NETWIB_ERR_PABASE64X4);
  netwib_er(netwibtest_buf_content2(&buf, ""));
  netwib_er(netwib_buf_close(&buf));

  netwib_er(netwib_buf_init_mallocdefault(&buf));
  netwib_er(netwib_buf_init_ext_text("444$", &buf2));
  netwib_eir(netwib_buf_decode(&buf2, NETWIB_DECODETYPE_BASE64, &buf),
             NETWIB_ERR_PABASE64CHAR);
  netwib_er(netwibtest_buf_content2(&buf, ""));
  netwib_er(netwib_buf_close(&buf));

  netwib_er(netwib_buf_init_mallocdefault(&buf));
  netwib_er(netwib_buf_init_ext_text("44==", &buf2));
  netwib_eir(netwib_buf_decode(&buf2, NETWIB_DECODETYPE_BASE64, &buf),
             NETWIB_ERR_PABASE64LO);
  netwib_er(netwibtest_buf_content2(&buf, ""));
  netwib_er(netwib_buf_close(&buf));

  netwib_er(netwib_buf_init_mallocdefault(&buf));
  netwib_er(netwib_buf_init_ext_text("", &buf2));
  netwib_eir(netwib_buf_decode(&buf2, NETWIB_DECODETYPE_QUOTED, &buf),
             NETWIB_ERR_DATAEND);
  netwib_er(netwibtest_buf_content2(&buf, ""));
  netwib_er(netwib_buf_close(&buf));
  netwib_er(netwib_buf_init_mallocdefault(&buf));
  netwib_er(netwib_buf_init_ext_text("  \t \t ", &buf2));
  netwib_eir(netwib_buf_decode(&buf2, NETWIB_DECODETYPE_QUOTED, &buf),
             NETWIB_ERR_DATAEND);
  netwib_er(netwibtest_buf_content2(&buf, ""));
  netwib_er(netwib_buf_close(&buf));
  netwib_er(netwib_buf_init_mallocdefault(&buf));
  netwib_er(netwib_buf_init_ext_text(" hello ", &buf2));
  netwib_er(netwib_buf_decode(&buf2, NETWIB_DECODETYPE_QUOTED, &buf));
  netwib_er(netwibtest_buf_content2(&buf, "hello"));
  netwib_er(netwibtest_buf_content2(&buf2, ""));
  netwib_er(netwib_buf_close(&buf));
  netwib_er(netwib_buf_init_mallocdefault(&buf));
  netwib_er(netwib_buf_init_ext_text(" hello\tbob ", &buf2));
  netwib_er(netwib_buf_decode(&buf2, NETWIB_DECODETYPE_QUOTED, &buf));
  netwib_er(netwibtest_buf_content2(&buf, "hello"));
  netwib_er(netwibtest_buf_content2(&buf2, "bob "));
  netwib_er(netwib_buf_close(&buf));
  netwib_er(netwib_buf_init_mallocdefault(&buf));
  netwib_er(netwib_buf_init_ext_text(" \"hello\"bob", &buf2));
  netwib_er(netwib_buf_decode(&buf2, NETWIB_DECODETYPE_QUOTED, &buf));
  netwib_er(netwibtest_buf_content2(&buf, "hello"));
  netwib_er(netwibtest_buf_content2(&buf2, "bob"));
  netwib_er(netwib_buf_close(&buf));
  netwib_er(netwib_buf_init_mallocdefault(&buf));
  netwib_er(netwib_buf_init_ext_text(" \"hello\"    bob", &buf2));
  netwib_er(netwib_buf_decode(&buf2, NETWIB_DECODETYPE_QUOTED, &buf));
  netwib_er(netwibtest_buf_content2(&buf, "hello"));
  netwib_er(netwibtest_buf_content2(&buf2, "bob"));
  netwib_er(netwib_buf_close(&buf));
  netwib_er(netwib_buf_init_mallocdefault(&buf));
  netwib_er(netwib_buf_init_ext_text(" \"he\\l\\\\l\no\"    bob", &buf2));
  netwib_er(netwib_buf_decode(&buf2, NETWIB_DECODETYPE_QUOTED, &buf));
  netwib_er(netwibtest_buf_content2(&buf, "hel\\l\no"));
  netwib_er(netwibtest_buf_content2(&buf2, "bob"));
  netwib_er(netwib_buf_close(&buf));
  netwib_er(netwib_buf_init_mallocdefault(&buf));
  netwib_er(netwib_buf_init_ext_text(" \"he\\x31o\"    bob", &buf2));
  netwib_er(netwib_buf_decode(&buf2, NETWIB_DECODETYPE_QUOTED, &buf));
  netwib_er(netwibtest_buf_content2(&buf, "he1o"));
  netwib_er(netwibtest_buf_content2(&buf2, "bob"));
  netwib_er(netwib_buf_close(&buf));
  netwib_er(netwib_buf_init_mallocdefault(&buf));
  netwib_er(netwib_buf_init_ext_text(" \"he", &buf2));
  netwib_eir(netwib_buf_decode(&buf2, NETWIB_DECODETYPE_QUOTED, &buf),
             NETWIB_ERR_DATANOTAVAIL);
  netwib_er(netwib_buf_close(&buf));
  netwib_er(netwib_buf_init_mallocdefault(&buf));
  netwib_er(netwib_buf_init_ext_text(" \"he\\", &buf2));
  netwib_eir(netwib_buf_decode(&buf2, NETWIB_DECODETYPE_QUOTED, &buf),
             NETWIB_ERR_DATANOTAVAIL);
  netwib_er(netwib_buf_close(&buf));

  return(NETWIB_ERR_OK);
}


/*-------------------------------------------------------------*/
/*-------------------------------------------------------------*/
netwib_err netwibtest_dat_bufdec(void)
{
  puts("###########################################\nTest of dat/bufdec");
  netwib_er(netwib_buf_decode_test());

  return(NETWIB_ERR_OK);
}

