#ifndef NEUTRINO_WINDOW_H
#define NEUTRINO_WINDOW_H

#include <gtk/gtkwindow.h>

#include <glade/glade.h>

#include "neutrino-shell.h"
#include "nomad-jukebox.h"

#define NEUTRINO_TYPE_WINDOW  (neutrino_window_get_type())
#define NEUTRINO_WINDOW(obj)  (G_TYPE_CHECK_INSTANCE_CAST( ( obj ), \
                              NEUTRINO_TYPE_WINDOW, \
                              NeutrinoWindow ) )
#define NEUTRINO_IS_WINDOW(obj)  (G_TYPE_CHECK_INSTANCE_TYPE( ( obj ), \
                                 NEUTRINO_TYPE_WINDOW ) )

#ifndef NEUTRINO_WINDOW_DEFINED
#define NEUTRINO_WINDOW_DEFINED
typedef struct NeutrinoWindow NeutrinoWindow;
#endif

typedef struct {
	GtkWindowClass parent_spot;

} NeutrinoWindowClass;

typedef struct NeutrinoWindowDetails NeutrinoWindowDetails;

enum {
	JUKEBOX_VIEW = 0,
	PLAYLIST_VIEW,
	SEARCH_VIEW
};

struct NeutrinoWindow {
	GtkWindow parent_object;

	NeutrinoWindowDetails *details;

	/* UI stuff */
	GladeXML *xml;

	GtkWidget *content_hbox;

	GtkWidget *filemanager;

	GtkWidget *albums;
	GtkWidget *artists;
	GtkWidget *tracks;

	GtkWidget *playqueue;
	guint playqueue_size;
	gint play_progress;
	gboolean had_zero;

	gpointer col;

	guint show_sidebar;
	guint show_browser;
	guint show_playback;
	guint show_toolbar;

	gboolean sidebar;
	gboolean browser;
	gboolean playback;
	gboolean toolbar;

	guint num_transfers;

	NeutrinoShell *shell;

	NomadJukebox *jukebox;
};

GType neutrino_window_get_type( void );
void neutrino_window_close( NeutrinoWindow *window );

void neutrino_window_set_jukebox( NeutrinoWindow *window,
				  NomadJukebox *jukebox );
void neutrino_window_upload( NeutrinoWindow *window );
void neutrino_window_download( NeutrinoWindow *window );
void neutrino_window_delete( NeutrinoWindow *window );

void neutrino_window_edit_meta( NeutrinoWindow *window );

void neutrino_window_new_playlist( NeutrinoWindow *window );
void neutrino_window_add_to_playlist( NeutrinoWindow *window );
void neutrino_window_delete_playlist( NeutrinoWindow *window );
void neutrino_window_rename_playlist( NeutrinoWindow *window );

void neutrino_window_jukebox_info( NeutrinoWindow *window );

void neutrino_window_edit_eax( NeutrinoWindow *window );

void neutrino_window_playback( NeutrinoWindow *window );

void neutrino_window_queue( NeutrinoWindow *window );

void neutrino_window_cancel( NeutrinoWindow *window );

void neutrino_window_select_all( NeutrinoWindow *window );

void neutrino_window_scan_jukeboxes( NeutrinoWindow *window );

#endif
