/*  VER 049   TAB P   $Id: util.c,v 1.14.2.1 2002/01/29 06:44:48 egil Exp $
 *
 *  file utilities     
 *
 *  copyright 1996, 1997 Egil Kvaleberg, egil@kvaleberg.no
 *  the GNU General Public License applies
 *
 *  $Log: util.c,v $
 *  Revision 1.14.2.1  2002/01/29 06:44:48  egil
 *  Changing from xmalloc, xrealloc, xstrcpy to
 *  malloc_perfect, realloc_perfect and strdup_perfect
 *
 *  Revision 1.14  1999/04/07 08:02:11  src
 *  Implemented --profile
 *
 *  Revision 1.13  1999/03/24 03:53:02  src
 *  Implemented "newsx" as magic exclude pattern
 *
 *  Revision 1.12  1999/03/11 07:30:01  src
 *  Implemented check for spool free space
 *
 *  Revision 1.11  1999/03/07 14:58:19  src
 *  Read newsconfig supported. Storage API supported.
 *
 *  Revision 1.10  1998/09/14 06:30:25  src
 *  *** empty log message ***
 *
 *  Revision 1.9  1998/09/14 06:07:19  src
 *  Cleaned up dbz -Wall
 *
 *  Revision 1.8  1998/09/11 09:17:44  src
 *  Check path consistency (--no-path) and length (--max-path)
 *  GNU style option --help, --version, --dry-run, changed --noxx to --no-xx
 *  Check for putenv and setenv, added xstrcpy
 *
 *  Revision 1.7  1998/09/09 07:32:15  src
 *  Version 1.1
 *
 *  Revision 1.6  1998/07/12 09:39:31  src
 *  newsx version 1.0
 */

#include "common.h"
#include "proto.h"
#include "options.h"
#include "stat.h"

/*
 *  append the contents of a file to another file
 *  returns 0 on error, 1 if all OK
 */
int 
append_file(FILE *f,char *name,FILE *af)
{                               
    int n;
    char buf[1024];

    if (fseek(f,0L,2) != 0) {
	log_msg(L_ERRno,"can't seek to end of \"%s\"", name);
	return 0;
    }

    while ((n = fread(buf,1,sizeof(buf),af)) > 0) {
	if (fwrite(buf,1,n,f) != n) {
	    /* append failed */
	    log_msg(L_ERR,"can't append to \"%s\"", name);
	    return 0;
	}
    }

    if (fflush(f) != 0) {
	log_msg(L_ERRno,"can't flush \"%s\"", name);
	return 0;
    }
    if (fseek(f,0L,0) != 0) {
	log_msg(L_ERRno,"can't seek to start of \"%s\"", name);
	return 0;
    }
    return 1;
}

/*
 *  rename a file 
 *  returns 0 on error
 */
int 
rename_file(char *from,char *to)
{
    if (rename(from,to) == EOF) {
	log_msg(L_ERRno,"can't rename \"%s\" to \"%s\"", from,to);
	return 0;
    }
    return 1;
}

/*
 *  check if it is a regular file
 *  as an added bonus, sets file size is desired
 */
int 
is_regular(FILE *f, char *name, long *sizep)
{
    struct stat st;

    /* verify that it is a regular file */
    if (fstat(fileno(f),&st) < 0) {
	log_msg(L_ERRno,"can't fstat \"%s\"", name);
	return 0;
    }
    /* BUG: both of these must be set: S_IRUSR S_IWUSR */
    if (!S_ISREG(st.st_mode)) { 
	log_msg(L_ERR,"\"%s\" is not a regular file", name);
	return 0;
    }
    if (sizep) *sizep = (long)(st.st_size);
    return 1;
}

/*
 *  build a file name, with a fixed default choice as well as a
 *  first prioroty alternative 
 *  both names may be absolute or relative paths
 */
void 
build_alt_filename(char *where, char *home, char *fixed, char *alt)
{                               
    char *name = (alt && alt[0]) ? alt : fixed;

    if (name[0]=='/' || name[0]=='.') {
	build_filename(where,name,NULL,NULL,NULL);
    } else {
	build_filename(where,home,"/",name,NULL);
    }
}

/*
 *  build a file name, max length PATH_MAX
 *  argument is a list of up to arguments, padded with NULL to make 4
 *  NOTE: a NULL-terminated argument list would have been neater,
 *        but it is simply not worth the effort to make it portable
 */
void 
build_filename(char *where,char *arg1,char *arg2,char *arg3,char *arg4)
{                               
    int len = 0;
    int n;
    char **argp;
    char *argv[5];

    argv[0] = arg1;
    argv[1] = arg2;
    argv[2] = arg3;
    argv[3] = arg4;
    argv[4] = NULL;

    for (argp = argv; *argp; ++argp) {
	if ((len += (n=strlen(*argp))) >= PATH_MAX) {
	    log_msg(L_ERR,"file name longer than %d chars", PATH_MAX-1);
	    exit_cleanup(1);
	}
	strcpy(where+len-n,*argp);
    }
}
	
/*
 *  convert time to text string, local time
 *  return static pointer
 *  "Wed Apr 10 11:00:00 1996"
 */
char *
text_time(time_t t)
{
    static char buf[50];
    char *p;

    strcpy(buf,asctime(localtime(&t)));
    /* remove trailing newline */
    if ((p=strchr(buf,'\n'))) *p = '\0';

    return buf;
}

/*
 *  skip blanks
 */
char *
skipsp(char *p)
{
    while (*p==' ' || *p=='\t') ++p;
    return p;
}

/*
 *  memory allocation - never fail
 */
void *
malloc_perfect(unsigned int size)
{  
    void *p;

    if (!(p = malloc(size))) {
	log_msg(L_ERR,"out of memory");
	unlock_exit(1);
    }
    return p;
}

/*
 *  memory reallocation - never fail
 */
void *
realloc_perfect(void *p,unsigned int size)
{  
    if (!(p = realloc(p,size))) {
	log_msg(L_ERR,"reallocation error, out of memory");
	unlock_exit(1);
    }
    return p;
}

/*
 *  string allocate and copy - never fail
 */
char *
strdup_perfect(const char *str)
{  
    return strcpy(malloc_perfect(strlen(str)+1),str);
}
