.\"
.\" %nmhwarning%
.\" $Id: nmh.man,v 1.5.2.2 2003/10/24 20:14:47 kenh Exp $
.\"
.TH NMH %manext1% "%nmhdate%" MH.6.8 [%nmhversion%]
.SH NAME
nmh \- new MH message system
.SH SYNOPSIS
any
.B nmh
command
.SH DESCRIPTION
.B nmh
is the name of a powerful message handling system.  Rather than
being a single comprehensive program,
.B nmh
consists of a collection
of fairly simple single-purpose programs to send, retrieve, save,
and manipulate messages.
.PP
Unlike most mail clients in UNIX,
.B nmh
is not a closed system which
must be explicitly run, then exited when you wish to return to the shell.
You may freely intersperse
.B nmh
commands with other shell commands,
allowing you to read and answer your mail while you have (for example)
a compilation running, or search for a file or run programs as needed
to find the answer to someone's question before answering their mail.
.PP
The rest of this manual entry is a quick tutorial which will teach you
the basics of
.BR nmh .
You should read the manual entries for the
individual programs for complete documentation.
.PP
To get started using
.BR nmh ,
put the directory
.I %bindir%
on your
.BR $PATH .
This is best done in one of the files:
.IR \&.profile ,
.IR \&.login ,
.IR \&.bashrc ,
or
.I \&.cshrc
in your home directory.  (Check the
manual entry for the shell you use, in case you don't know how to
do this.)  Run the
.B install-mh
command.  If you've never used
.B nmh
before, it will create the necessary default files and directories after
asking you if you wish it to do so.
.PP
.B inc
moves mail from your system maildrop into your
.B nmh
`+inbox' folder, breaking it up into separate files and converting it
to
.B nmh
format as it goes.  It prints one line for each message it
processes, containing the from field, the subject field and as much of
the first line of the message as will fit.  It leaves the first message
it processes as your current message.  You'll need to run
.B inc
each
time you wish to incorporate new mail into your
.B nmh
file.
.PP
.B scan
.B prints a list of the messages in your current folder.
.PP
The commands:
.BR show ,
.BR next ,
and
.B prev
are used to read
specific messages from the current folder.
.B show
displays the
current message, or a specific message, which may be specified by its
number, which you pass as an argument to
.BR show .
.B next
and
.B prev
display, respectively, the message numerically after or before
the current message.  In all cases, the message displayed becomes the
current message.  If there is no current message,
.B show
may be
called with an argument, or
.B next
may be used to advance to the
first message.
.PP
.B rmm
(remove message) deletes the current message.  It may be called
with message numbers passed as arguments, to delete specific messages.
.PP
.B repl
is used to respond to the current message (by default).
It places you in the editor with a prototype response form.  While you're
in the editor, you may peruse the item you're responding to by reading
the file
.IR @ .
After completing your response, type
.B l
to
.B list
(review) it, or
.B s
to
.B send
it.
.PP
.B comp
allows you to compose a message by putting you in the editor
on a prototype message form, and then lets you send it.
.PP
All the
.B nmh
commands may be run with the single argument:
.BR \-help ,
which causes them to print a list of the arguments they may be invoked
with and then exit.
.PP
All the
.B nmh
commands may be run with the single argument:
.BR \-version ,
which cause them to print the version number of the
.B nmh
distribution, and then exit.
.PP
Commands which take a message number as an argument (
.BR scan ,
.BR show ,
.BR repl ,
\&...)  also take one of the words: \*(lqfirst\*(rq,
\*(lqprev\*(rq, \*(lqcur\*(rq, \*(lqnext\*(rq, or \*(lqlast\*(rq to indicate
(respectively) the first, previous, current, next, or last message in
the current folder (assuming they are defined).

Commands which take a range of message numbers (
.BR rmm ,
.BR scan ,
.BR show ,
\&...)  also take any of the abbreviations:
.PP
.RS 5
.IP \fI<num1>\fR\-\fI<num2>\fR 15
Indicates all messages in the range <num1> to <num2>, inclusive. The range must be nonempty.
.IP \fI<num>\fR:+\fIN\fR 15
.IP \fI<num>\fR:\-\fIN\fR 15
Up to
.I N
messages beginning with (or ending with) message
.IR num .
.I Num
may be any of the pre-defined symbols:
.IR first ,
.IR prev ,
.IR cur ,
.I next
or
.IR last .
.IP first:\fIN\fR 15
.IP prev:\fIN\fR 15
.IP next:\fIN\fR 15
.IP last:\fIN\fR 15
The first, previous, next or last
messages, if they exist.
.RE
.PP
There are many other possibilities such as creating multiple folders
for different topics, and automatically refiling messages according to
subject, source, destination, or content.  These are beyond the scope
of this manual entry.
.PP
Following is a list of all the
.B nmh
commands:
.PP
.RS 5
.fc ^ ~
.nf
.ta 1.5i
^ali(1)~^\- list mail aliases
^anno(1)~^\- annotate messages
^burst(1)~^\- explode digests into messages
^comp(1)~^\- compose a message 
^dist(1)~^\- redistribute a message to additional addresses
^flist(1)~^\- list folders with messages in given sequence(s)
^flists(1)~^\- list all folders with messages in given sequence(s)
^folder(1)~^\- set/list current folder/message
^folders(1)~^\- list all folders
^forw(1)~^\- forward messages
^inc(1)~^\- incorporate new mail
^mark(1)~^\- mark messages
^mhbuild(1)~^\- translate MIME composition draft
^mhl(1)~^\- produce formatted listings of nmh messages
^mhlist(1)~^\- list information about content of MIME messages
^mhmail(1)~^\- send or read mail
^mhn(1)~^\- display/list/store/cache MIME messages
^mhparam(1)~^\- print nmh profile components
^mhpath(1)~^\- print full pathnames of nmh messages and folders
^mhshow(1)~^\- display MIME messages
^mhstore(1)~^\- store contents of MIME messages into files
^msgchk(1)~^\- check for messages
^msh(1)~^\- nmh shell(and BBoard reader)
^next(1)~^\- show the next message
^packf(1)~^\- compress a folder into a single file
^pick(1)~^\- select messages by content
^prev(1)~^\- show the previous message
^prompter(1)~^\- prompting editor front end
^rcvdist(1)~^\- asynchronously redistribute new mail
^rcvpack(1)~^\- append message to file
^rcvstore(1)~^\- asynchronously incorporate new mail
^rcvtty(1)~^\- report new mail
^refile(1)~^\- file messages in other folders
^repl(1)~^\- reply to a message
^rmf(1)~^\- remove folder
^rmm(1)~^\- remove messages
^scan(1)~^\- produce a one line per message scan listing
^send(1)~^\- send a message
^sendfiles(1)~^\- send multiple files and directories in MIME message
^show(1)~^\- show(display) messages
^slocal(1)~^\- asynchronously filter and deliver new mail
^sortm(1)~^\- sort messages
^whatnow(1)~^\- prompting front\-end for send
^whom(1)~^\- report to whom a message would go
.sp
^mh\-alias(5)~^\- alias file for nmh message system
^mh\-draft(5)~^\- draft folder facility
^mh\-format(5)~^\- format file for nmh message system
^mh\-mail(5)~^\- message format for nmh message system
^mh\-profile(5)~^\- user customization for nmh message system
^mh\-sequence(5)~^\- sequence specification for nmh message system
^mh\-tailor(5)~^\- mail transport customization for nmh message system
.sp
^ap(8)~^\- parse addresses 822\-style
^conflict(8)~^\- search for alias/password conflicts
^dp(8)~^\- parse dates 822\-style
^fmtdump(8)~^\- decode \fInmh\fP format files
^install\-mh(8)~^\- initialize the nmh environment
^post(8)~^\- deliver a message
.fi
.RE

.SH FILES
.fc ^ ~
.nf
.ta \w'%etcdir%/ExtraBigFileName  'u
^%bindir%~^contains \fInmh\fR commands
^%etcdir%~^contains \fInmh\fR format files
^%libdir%~^contains \fInmh\fR library commands
^$HOME/\&.mh\(ruprofile~^The user profile
.fi

.SH "PROFILE COMPONENTS"
.fc ^ ~
.nf
.ta 2.4i
.ta \w'ExtraBigProfileName  'u
^Path:~^To determine the user's nmh directory
.fi

.SH BUGS
If problems are encountered with an
.B nmh
program, the problems should
be reported to the local maintainers of
.BR nmh .
When doing this, the
name of the program should be reported, along with the version information
for the program.
.br
To find out what version of an
.B nmh
program is being run, invoke
the program with the
.B \-version
switch.  This information includes
the version of
.BR nmh ,
the host it was generated on, and the date the
program was loaded.
.PP
Send bug reports and suggestions to
.IR nmh-workers@mhost.com .
.SH "SEE ALSO"
mh-chart(1)
