open Ocamldap
open Ooldap
open Ooldif
open Arg
open Printf

let _ = 
  (* stuff to handle command line args *)
  let usg = "testoo -h <host> -p <port> -D <dn> -w <pass> -b <base> <filter>" in
  let host = ref "" in
  let port = ref 389 in
  let binddn = ref "" in
  let cred = ref "" in
  let base = ref "" in
  let filter = ref "" in
  let set_host x = host := x in
  let set_port x = port := x in
  let set_binddn x = binddn := x in
  let set_cred x = cred := x in
  let set_base x = base := x in
  let set_filter x = filter := x in
  let spec = [("-h", String(set_host), "host");
	      ("-p", Int(set_port), "port");
	      ("-D", String(set_binddn), "dn to bind with");
	      ("-w", String(set_cred), "password to use when binding");
	      ("-b", String(set_base), "search base")] in


    (* do the ldap part *)
    try
      if (Array.length Sys.argv) > 9 then
	(parse spec set_filter usg;
	 let ldap = new ldapcon !host ~port: !port in
	 let ldif = new ldif () in
	   ldap#bind  !binddn ~cred: !cred;
	   Ooldap.iter
	     (fun e -> ldif#write_entry e) 
	     (ldap#search_a ~base: !base !filter))
      else
	usage spec usg
    with
	LDAP_Failure e -> printf "ldap error: %s" (err2string e)
