function [IDX] = strfind(text,pattern)
## STRFIND identifies the starting position of substrings
##  [IDX] = STRFIND(STRING,SUBSTRING) 
##  
## Unlike FINDSTR, STRFIND yields an empty IDX if SUBSTRING 
## is longer than STRING.
##
## see also: FINDSTR, STRMATCH, STRCMP

## This program is free software; you can redistribute it and/or
## modify it under the terms of the GNU General Public License
## as published by the Free Software Foundation; either version 2
## of the License, or (at your option) any later version.
## 
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
## 
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

##	$Id: strfind.m,v 1.1 2004/11/01 18:37:31 schloegl Exp $
##	Copyright (C) 2004 by Alois Schloegl <a.schloegl@ieee.org>	
##      This function is part of Octave-Forge http://octave.sourceforge.net/

lp  = length(pattern);
lt  = length(text);

k = 0; 
IDX  = 1:lt-lp+1;
while (k<lp) & ~isempty(IDX),
    tmp = text(IDX+k);
    IDX = IDX(tmp==pattern(++k));
end;






