## Copyright (C) 2000  Etienne Grossman
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

##       [r,c] = sub2ind(sz,i)
##
## r and c are the row and column of the i'th element of a matrix of
## size sz. That is, r = 1+rem(i,sz(1)), c = 1+floor(i/sz(1)).
##
## See also sub2ind.
##

## Author:        Etienne Grossmann  <etienne@isr.ist.utl.pt>
## Last modified: January 2000

function [r,c] = sub2ind(sz,ii)
  r = 1+rem(ii-1,sz(1));
  c = 1+floor((ii-1)/sz(1));
