## Copyright (C) 1996 John W. Eaton
##
## This program is free software; you can redistribute it and/or modify it
## under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
##
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; see the file COPYING.  If not, write to the Free
## Software Foundation, 59 Temple Place - Suite 330, Boston, MA
## 02111-1307, USA.

## __plt3__ is not a user callable function

## Author: Paul Kienzle <kienzle.powernet.co.uk>

function __plt3__ (x, y, z, fmt)

  [rx, cx] = size(x);
  [ry, cy] = size(y);
  [rz, cz] = size(z);

  if all([rx, ry, rz, cx, cy, cz] != 1)
    if (cx != cy || cx != cz)
      error("plot3: x, y, and z must have the same number of columns");
    endif
  else
    if cx != 1, x = x.'; endif
    if cy != 1, y = y.'; endif
    if cz != 1, z = z.'; endif
    [rx, cx] = size(x);
    [ry, cy] = size(y);
    [rz, cz] = size(z);
  endif

  if (rx != ry || rx != rz)
    error("plot3: x, y, and z must have the same length");
  endif

  unwind_protect
    gset parametric;
    for i=1:cx
      tmp = [x(:,i), y(:,i), z(:,i)];
      eval(sprintf("gsplot tmp %s", fmt));
    endfor
  unwind_protect_cleanup
    gset noparametric; 
  end_unwind_protect
endfunction
