#ifndef PREFS_WIN_H
#define PREFS_WIN_H

#include <kdialogbase.h>

class QLineEdit;
class QComboBox;
class QCheckBox;

class PrefsWin : public KDialogBase
{
 Q_OBJECT
public:
 PrefsWin(QWidget* /*parent*/);

 void setAutoPlay(bool /*autoplay*/);
 bool autoPlay()const;

 void setAutoFullScreen(bool /*autofullscreen*/);
 bool autoFullScreen()const;

 void setDisableScreenSaver(bool /*screensaver*/);
 bool disableScreenSaver()const;

 void setDisableDPMS(bool /*dpms*/);
 bool disableDPMS()const;
 
 void setDVDPath(const QString& /*dvdpath*/);
 QString DVDPath()const;
 
 void setRegion(int /*region*/);
 int region()const;

 void setDefaultAudio(const QString& /*audiolanguage*/);
 QString defaultAudio()const;

 void setDefaultSubtitle(const QString& /*subtitle*/);
 QString defaultSubtitle()const;

 void setDefaultMenuLanguage(const QString& /*menulanguage*/);
 QString defaultMenuLanguage()const;

 void setParentalLevel(int /*parentallevel*/);
 int parentalLevel()const;

 void setParentalCountry(const QString& /*parentalcountry*/);
 QString parentalCountry()const;
public slots:
 void slotDefault();
private:
 void initPageDevice();
 void initPageStartup();
 void initPageDefaults();

 QCheckBox* _autoplay;
 QCheckBox* _autofullscreen;
 QCheckBox* _disablescreensaver;
 QCheckBox* _disabledpms;

 QLineEdit* _dvdp;
 QComboBox* _region;
 
 QComboBox* _defaudio;
 QComboBox* _defsub;
// QComboBox* _defangle;
 QComboBox* _defmenulang;
 
 QComboBox* _parentalcountry;
 QComboBox* _parentallevel;

 QFrame *pageDevice,*pageStartup,*pageDefaults;
};

#endif // PREFS_WIN_H
