# scanconv-lib.tcl --
#
#       Library of abstractions to adjust the scan converter through the amxd.
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

# these functions must be called from a program with direct access to the
#   amx-lib functions (i.e., on the AMX Daemon server)
#
# this library assumes that the AMX has already been setup with
#   setup-AMX-control

source amx-lib.tcl

# these are defined in amx-lib.tcl
#global g_amxDevices

proc scanConv_switchMode {mode} {
    global g_amxDevices

    set dev $g_amxDevices(scanConverter)

    puts stdout "mode is $mode"
    
    switch -exact -- $mode {
	800x600 {
	    set str "MEMORY 1,0"
	}
	640x480 {
	    set str "MEMORY 2,0"
	}
	1024x768 {
	    set str "MEMORY 3,0"
	}
	sgi {
	    set str "MEMORY 4,0"
	}
	default {
	    return -code error "scanConv_switchMode: mode must be \[640x480, 800x600, 1024x768, sgi\]"
	}
    }
    set str [binary format "a*c" $str 0x0D]
    send-AMX-command 4 $dev $str
}

proc scanConv_adjustSize {dir} {
    global g_amxDevices

    set dev $g_amxDevices(scanConverter)

    switch -exact -- $dir {
	tall {
	    set str "SIZE +0,+1"
	}
	short {
	    set str "SIZE +0,+-1"
	}
	narrow {
	    set str "SIZE +-1,+0"
	}
	wide {
	    set str "SIZE +1,+0"
	}
	default {
	    return -code error "scanConv_adjustSize: dir must be \[wide, narrow, tall, short\]"
	}
    }
    set str [binary format "a*c" $str 0x0D]
    send-AMX-command 4 $dev $str
}

proc scanConv_adjustPosition {dir} {
    global g_amxDevices

    set dev $g_amxDevices(scanConverter)

    switch -exact -- $dir {
	up {
	    set str "POSITION +0,+-1"
	}
	down {
	    set str "POSITION +0,+1"
	}
	right {
	    set str "POSITION +1,+0"
	}
	left {
	    set str "POSITION +-1,+0"
	}
	default {
	    return -code error "scanConv_adjustPosition: dir must be \[up, down, right, left\]"
	}
    }
    set str [binary format "a*c" $str 0x0D]
    send-AMX-command 4 $dev $str
}
