/*
 * pan-scan.cc --
 *
 *      A pan and scan effect
 *
 * Copyright (c) 1993-2001 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/* @(#) $Header: /usr/mash/src/repository/mash/mash-1/fx/effects/pan-scan.cc,v 1.1 2002/02/07 04:18:19 chema Exp $ */


#include <dvmbasic.h>
#include <dvmbytegeom.h>

#include "pan-scan.h"



PanScanEffect::PanScanEffect(int decimation) 
	: EffectModule(1, decimation)
{
	coordinates_.x1 = 0.2;
	coordinates_.y1 = 0.2;
	coordinates_.x2 = 0.7;
	coordinates_.y2 = 0.7;

	return;
}



int PanScanEffect::command(int argc, const char*const* argv)
{
	return (EffectModule::command(argc, argv));
}



void PanScanEffect::trigger_effect (Uncompressed* input)
{
	//printf ("w(%dx%d) ", input->w_, input->h_); fflush (stdout); // XXX

	int w = input->w_;
	int h = input->h_;

	float in_css_h = (float)input->css_h_;
	float in_css_v = (float)input->css_v_;

	float roi_x1 = coordinates_.x1;
	float roi_x2 = coordinates_.x2;
	float roi_y1 = coordinates_.y1;
	float roi_y2 = coordinates_.y2;

	if (roi_x2 == roi_x1) {
		roi_x2 += 0.01;
	}
	if (roi_y2 == roi_y1) {
		roi_y2 += 0.01;
	}

	float sx = 1.0 / (roi_x2 - roi_x1);
	float sy = 1.0 / (roi_y2 - roi_y1);

	float tx = roi_x1 * w * -1;
	float ty = roi_x1 * h * -1;

	float la = sx;
	float lb = 0.0;
	float lc = tx * sx;
	float ld = 0.0;
	float le = sy;
	float lf = ty * sy;

	float ca = sx;
	float cb = 0.0;
	float cc = tx * sx / in_css_h;
	float cd = 0.0;
	float ce = sy;
	float cf = ty * sy / in_css_v;

	ByteImage *in_l = input->lum_;
	ByteImage *in_cr = input->cr_;
	ByteImage *in_cb = input->cb_;

	ByteImage *out_l = output_->lum_;
	ByteImage *out_cr = output_->cr_;
	ByteImage *out_cb = output_->cb_;

	ByteAffine (in_l, out_l, la, lb, lc, ld, le, lf);
	ByteAffine (in_cr, out_cr, ca, cb, cc, cd, ce, cf);
	ByteAffine (in_cb, out_cb, ca, cb, cc, cd, ce, cf);

	// deliver the output frame
	deliver_frame();

	return;
}

