/*
 * mbv2.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 *  @(#) $Header: /usr/mash/src/repository/mash/mash-1/mbv2/mbv2.h,v 1.11 2002/02/03 03:17:08 lim Exp $
 */

#ifndef MASH_MBV2_H
#define MASH_MBV2_H

#include "tclcl.h"
#include "misc/all-types.h"
#include "srmv2-api.h"
#include <sys/time.h>


//typedef int MBv2SourceId[4];


struct MBv2PageId {
	int srcid[4];
	int pageid;

	MBv2PageId() { srcid[0] = srcid[1] = srcid[2] = srcid[3] = pageid = 0;}
	MBv2PageId(const char *string) {
		string = srm_str2srcid(string, srcid);
		// ignore the ":"
		pageid = strtoul(string+1, NULL, 10);
	}

	inline friend int operator== (const MBv2PageId &p1, const MBv2PageId &p2) {
		return (p1.srcid[0]==p2.srcid[0] &&
			p1.srcid[1]==p2.srcid[1] &&
			p1.srcid[2]==p2.srcid[2] &&
			p1.srcid[3]==p2.srcid[3] &&
			p1.pageid  ==p2.pageid);
	}

	inline void to_string(char *string) const {
		srm_srcid2str(srcid, string);
		sprintf(string + strlen(string), ":%d", pageid);
	}
};


typedef unsigned int MBv2CmdId;
#define MBv2InvalidCmdId 0xFFFFFFFF


typedef unsigned int MBv2CanvId;
#define MBv2InvalidCanvId 0xFFFFFFFF


struct MBv2Time : public ntp64 {
	MBv2Time() { lower = upper = 0; }
	friend int operator >= (const MBv2Time &t1, const MBv2Time &t2) {
		return (t1.upper>t2.upper ||
			(t1.upper==t2.upper && t1.lower>=t2.lower));
	}
};


struct MBv2Color {
	u_int16_t r;        /* red */
	u_int16_t g;        /* green */
	u_int16_t b;        /* blue */
	u_int16_t a;        /* transparency = 1 => transparent, 0 otherwise*/
};


struct MBv2Point {
	int32_t x;
	int32_t y;
};


#define MBv2CmdChars_ReplaceText ((u_int16_t)-1)

typedef enum {
	MBv2Create=1,                // 1 MBv2CmdCreate
	MBv2Group,                   // 2 MBv2CmdGroup
	MBv2Delete,                  // 3 MBv2CmdDelete
	MBv2Move,                    // 4 MBv2CmdMove
	MBv2Copy,                    // 5 MBv2CmdCopy
	MBv2Undelete,                // 6 MBv2CmdCopy
	MBv2EditText,                // 7 MBv2CmdCopy
	MBv2Char,                    // 8 MBv2CmdChars
	MBv2Chars,                   // 9 MBv2CmdChars
	MBv2Invalid
} MBv2CmdType;


typedef enum {
	MBv2NoItem=0,
	MBv2Line,
	MBv2Text,
	MBv2Rect,
	MBv2Oval,
	MBv2Image,
	MBv2PS,
	MBv2InvalidItem
} MBv2ItemType;


typedef enum {
	MBv2ArrowNone=0,
	MBv2ArrowFirst,
	MBv2ArrowLast,
	MBv2ArrowBoth,
	MBv2ArrowInvalid
} MBv2ArrowType;


typedef enum {
	MBv2JustifyLeft=0,
	MBv2JustifyRight,
	MBv2JustifyCenter,
	MBv2JustifyInvalid
} MBv2JustifyType;


struct MBv2Dependency {
	u_int32_t cid;
	MBv2CmdId cmd;
	u_int32_t degree;
};



/* define ntoh/hton functions */

inline u_int32_t ntoh(u_int32_t i) { return ntohl(i); }
inline u_int32_t hton(u_int32_t i) { return htonl(i); }

inline int ntoh(int i) { return ntohl(i); }
inline int hton(int i) { return htonl(i); }

inline u_int16_t ntoh(u_int16_t i) { return ntohs(i); }
inline u_int16_t hton(u_int16_t i) { return htons(i); }

inline MBv2PageId ntoh(const MBv2PageId &p1) {
	MBv2PageId p2;
	p2.srcid[0] = ntoh(p1.srcid[0]);
	p2.srcid[1] = ntoh(p1.srcid[1]);
	p2.srcid[2] = ntoh(p1.srcid[2]);
	p2.srcid[3] = ntoh(p1.srcid[3]);
	p2.pageid   = ntoh(p1.pageid);
	return p2;
}
inline MBv2PageId hton(const MBv2PageId &p1) {
	MBv2PageId p2;
	p2.srcid[0] = hton(p1.srcid[0]);
	p2.srcid[1] = hton(p1.srcid[1]);
	p2.srcid[2] = hton(p1.srcid[2]);
	p2.srcid[3] = hton(p1.srcid[3]);
	p2.pageid   = hton(p1.pageid);
	return p2;
}

inline MBv2Color ntoh(const MBv2Color &c1) {
	MBv2Color c2;
	c2.r = ntoh(c1.r);
	c2.g = ntoh(c1.g);
	c2.b = ntoh(c1.b);
	c2.a = ntoh(c1.a);
	return c2;
}
inline MBv2Color hton(const MBv2Color &c1) {
	MBv2Color c2;
	c2.r = hton(c1.r);
	c2.g = hton(c1.g);
	c2.b = hton(c1.b);
	c2.a = hton(c1.a);
	return c2;
}


/*
 * NTP routines
 */


/*
 * convert microseconds to fraction of second * 2^32 (i.e., the lsw of
 * a 64-bit ntp timestamp).  This routine uses the factorization
 * 2^32/10^6 = 4096 + 256 - 1825/32 which results in a max conversion
 * error of 3 * 10^-7 and an average error of half that.
 */
inline u_int32_t usec2ntp(u_int32_t usec)
{
	u_int32_t t = (usec * 1825) >> 5;
	return ((usec << 12) + (usec << 8) - t);
}
inline MBv2Time current_time() {
	timeval tv;
	::gettimeofday(&tv, 0);
	MBv2Time t;
	t.upper = (u_int32_t)tv.tv_sec + GETTIMEOFDAY_TO_NTP_OFFSET;
	t.lower = usec2ntp((u_int32_t)tv.tv_usec);
	return (t);
}



#endif /* #ifdef MASH_MBV2_H */
