# tcltrace.tcl --
#
#       trace only certain classes -- tcl-side only!
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


# trace only certain classes -- tcl-side only!
#
# don't bother creating new instances -- just say
#     import Trace
# in relevent files, and to put a trace msg, call
#     Trc flag "my msg"
# or
#     Trc "my msg"
#<p>
# Indicate which flags to trace via:
#    Trace on|off
#    Trace add FLAG ...
# and/or
#    Trace rm FLAG ...
#
# e.g., for class-level ctrl of method tracing, in instprocs put:
#    Trc $class "--> ${class}::$proc"
#
# Precedence is as follows: on/off first, then individual flags,
# 	but if onoff==1 and flags="", trace everything
#
Class Trace

Trace set flags ""
Trace set onoff 0

Trace proc add {args} {
	set f [Trace set flags]
	foreach a $args {
		if {[lsearch -exact $f $a]==-1} {
			lappend f $a
		}
	}
	Trace set flags $f
}

Trace proc rm {args} {
	set f [Trace set flags]
	foreach a $args {
		set idx [lsearch -exact $f $a]
		if {$idx != -1} {
			set f [lreplace $f $idx $idx]
		}
	}
	Trace set flags $f
}

Trace proc on {} {Trace set onoff 1}
Trace proc off {} {Trace set onoff 0}

proc Trc {flag {msg ""}} {
	if ![Trace set onoff] {return}
	set t [clock format [clock seconds] -format {%H:%M:%S}]
	if {$msg == ""} {
		puts "\[$t\] Trc: $flag" ;# `flag' is actually the msg
	} else {
		set f [Trace set flags]
		if {$f == "" || [lsearch $f $flag] != -1} {
			puts "\[$t\] Trc - $flag: $msg"
		}
	}
}
