# main-announcer.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


import Application ScopeZone SDPParser SAPAnnouncer Program

#
Class SDAnnouncerApplication -superclass Application

#
SDAnnouncerApplication public init argv {
    $self next sdannouncer

    set o [$self options]
    set args [$o parse_args $argv]

    set l [llength $args]
    if {$l<1 || $l>2} {
	$self usage
	exit 1
    }

    eval $self init_announcer $args
}

#
SDAnnouncerApplication private init_announcer {file {range "224.2.128.0/17"}} {
    $self instvar scope_ announcer_

    set scope_ [new ScopeZone $range]
    set announcer_ [new SAPAnnouncer $scope_]

    if [catch {set fp [open $file r]} m] {
	$self fatal "Cannot open file $file: $m"
    }
    set sdp [read $fp]
    close $fp

    set p [new SDPParser]
    set msg [$p parse $sdp]
    if {$msg == ""} {
	$self fatal "SDP Parser Error: [$p parse_error]"
    }
    delete $p

    set prog [new Program $msg]

    $announcer_ addprog $self $prog
}

new SDAnnouncerApplication $argv
vwait forever
