# camapp.tcl --
#
#       Test app for controlling cameras using vcc3d and amxd
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

Import enable

import Application 405Client

Class CameraApp -superclass Application

CameraApp instproc init {argv} {
    $self instvar 405_

    $self next $argv
    set 405_ [new 405Client]
    $self init_ui
}

CameraApp instproc init_ui {} {
    global g_camSelect
    $self instvar 405_

    wm title . "Camera Control"

    frame .select_frame
    pack .select_frame -fill x -side top

    radiobutton .select_frame.speakerBut -text "Speaker" -variable g_camSelect -value "speaker"
    pack .select_frame.speakerBut -side top

    radiobutton .select_frame.audienceBut -text "Audience" -variable g_camSelect -value "audience"
    pack .select_frame.audienceBut -side top

    set g_camSelect "speaker"

    # controls for moving the camera
    frame .controls_frame

    pack .controls_frame -side top

    frame .controls_frame.top -borderwidth 3
    frame .controls_frame.middle -borderwidth 3
    frame .controls_frame.bottom -borderwidth 3
    frame .controls_frame.bottom2 -borderwidth 3

    button .controls_frame.top.up -text " Up " -command "$self move_camera up 1"
    button .controls_frame.middle.left -text "Left" -command "$self move_camera left 1"
    button .controls_frame.middle.center -text "Center" -width 4  -command "$self center_camera"
    button .controls_frame.middle.right -text "Right" -command "$self move_camera right 1"
    button .controls_frame.bottom.down -text "Down" -command "$self move_camera down 1"
    button .controls_frame.bottom2.in -text "In" -width 3 -command "$self move_camera in 1"
    button .controls_frame.bottom2.out -text "Out" -width 3 -command "$self move_camera out 1"

    pack .controls_frame.top -side top -fill x
    pack .controls_frame.top.up -side top

    pack .controls_frame.middle -side top
    pack .controls_frame.middle.left -side left
    pack .controls_frame.middle.center -side left
    pack .controls_frame.middle.right -side right

    pack .controls_frame.bottom -side top
    pack .controls_frame.bottom.down -side top

    pack .controls_frame.bottom2 -side top
    pack .controls_frame.bottom2.in -side left -ipadx 2
    pack .controls_frame.bottom2.out -side right -ipadx 2

#####

    # controls for moving the camera
    set cur_frame .controls_frame2
    frame $cur_frame
    pack $cur_frame -side top

    frame $cur_frame.top -borderwidth 3
    frame $cur_frame.middle -borderwidth 3
    frame $cur_frame.bottom -borderwidth 3
    frame $cur_frame.bottom2 -borderwidth 3

    button $cur_frame.top.up -text " Up "
    bind $cur_frame.top.up <Button-1> "$self start_move up"
    bind $cur_frame.top.up <ButtonRelease-1> "$self stop_move"

    button $cur_frame.middle.left -text "Left"
    bind $cur_frame.middle.left <Button-1> "$self start_move left"
    bind $cur_frame.middle.left <ButtonRelease-1> "$self stop_move"

    button $cur_frame.middle.center -text "Home" -width 4 -command "$self center_camera"

    button $cur_frame.middle.right -text "Right"
    bind $cur_frame.middle.right <Button-1> "$self start_move right"
    bind $cur_frame.middle.right <ButtonRelease-1> "$self stop_move"

    button $cur_frame.bottom.down -text "Down"
    bind $cur_frame.bottom.down <Button-1> "$self start_move down"
    bind $cur_frame.bottom.down <ButtonRelease-1> "$self stop_move"

    button $cur_frame.bottom2.in -text "In" -width 3
    bind $cur_frame.bottom2.in <Button-1> "$self start_move in"
    bind $cur_frame.bottom2.in <ButtonRelease-1> "$self stop_move"
    button $cur_frame.bottom2.out -text "Out" -width 3
    bind $cur_frame.bottom2.out <Button-1> "$self start_move out"
    bind $cur_frame.bottom2.out <ButtonRelease-1> "$self stop_move"

    pack $cur_frame.top -side top -fill x
    pack $cur_frame.top.up -side top

    pack $cur_frame.middle -side top
    pack $cur_frame.middle.left -side left
    pack $cur_frame.middle.center -side left
    pack $cur_frame.middle.right -side right

    pack $cur_frame.bottom -side top
    pack $cur_frame.bottom.down -side top

    pack $cur_frame.bottom2 -side top
    pack $cur_frame.bottom2.in -side left -ipadx 2
    pack $cur_frame.bottom2.out -side right -ipadx 2

#####

    frame .presets
    pack .presets -fill x -side top

    frame .presets.set_frame
    pack .presets.set_frame -fill x -side top

    button .presets.set_frame.set1 -text "Set 1" -command "$self set_preset 1"
    pack .presets.set_frame.set1 -side left
    button .presets.set_frame.set2 -text "Set 2" -command "$self set_preset 2"
    pack .presets.set_frame.set2 -side left
    button .presets.set_frame.set3 -text "Set 3" -command "$self set_preset 3"
    pack .presets.set_frame.set3 -side left
    button .presets.set_frame.set4 -text "Set 4" -command "$self set_preset 4"
    pack .presets.set_frame.set4 -side left
    button .presets.set_frame.set5 -text "Set 5" -command "$self set_preset 5"
    pack .presets.set_frame.set5 -side left
    button .presets.set_frame.set6 -text "Set 6" -command "$self set_preset 6"
    pack .presets.set_frame.set6 -side left

    frame .presets.go_frame
    pack .presets.go_frame -fill x -side top

    button .presets.go_frame.set1 -text "Go 1" -command "$self go_preset 1"
    pack .presets.go_frame.set1 -side left
    button .presets.go_frame.set2 -text "Go 2" -command "$self go_preset 2"
    pack .presets.go_frame.set2 -side left
    button .presets.go_frame.set3 -text "Go 3" -command "$self go_preset 3"
    pack .presets.go_frame.set3 -side left
    button .presets.go_frame.set4 -text "Go 4" -command "$self go_preset 4"
    pack .presets.go_frame.set4 -side left
    button .presets.go_frame.set5 -text "Go 5" -command "$self go_preset 5"
    pack .presets.go_frame.set5 -side left
    button .presets.go_frame.set6 -text "Go 6" -command "$self go_preset 6"
    pack .presets.go_frame.set6 -side left

    # make exit button
    button .exit -text "Exit" -command exit
    pack .exit -side bottom
}

CameraApp public start_move {dir} {
    global g_camSelect
    $self instvar 405_

    $405_ camera_startMove $g_camSelect $dir
}

CameraApp public stop_move {} {
    global g_camSelect
    $self instvar 405_

    $405_ camera_stopMove $g_camSelect
}

CameraApp public move_camera {argument num_times} {
    global g_camSelect
    $self instvar 405_

    $405_ camera_pulseMove $g_camSelect $argument $num_times
}

CameraApp public center_camera {} {
    global g_camSelect
    $self instvar 405_

    $405_ camera_center $g_camSelect
}

CameraApp public set_preset { num } {
    global g_camSelect
    $self instvar 405_

    $405_ camera_setPreset $g_camSelect $num
}

CameraApp public go_preset { num } {
    global g_camSelect
    $self instvar 405_

    $405_ camera_goPreset $g_camSelect $num
}

# driver engine

set app [new CameraApp $argv]

# next line is very important!!!
vwait forever

