/*
 * tgmb-prefs.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */


#include "tg-app.h"
#include "tgmb-prefs.h"
#include "tgmb-resource.h"


inline int CharIsSpace(char ch)
{
	return (ch==' ' || ch=='\t' || ch=='\n' || ch=='\r');
}


static void StrTrim(CharPtr string)
{
	CharPtr ptr = string+StrLen(string)-1;

	while (ptr >= string && CharIsSpace(*ptr)) ptr--;
	*(ptr+1) = '\0';

	ptr = string;
	while(*ptr != '\0' && CharIsSpace(*ptr)) ptr++;
	if (ptr > string) {
		while(*ptr != '\0') *string++ = *ptr++;
		*string = '\0';
	}
}


TGMB_Preferences::TGMB_Preferences()
{
	FromSystem();
}


void
TGMB_Preferences::ToSystem()
{
	PrefSetAppPreferences(TGMB_APPTYPE, PREF_USER_NAME, 1, userName_,
			      sizeof(userName_), true);
	PrefSetAppPreferences(TGMB_APPTYPE, PREF_RMX_SVR, 1, rmxSvr_,
			      sizeof(rmxSvr_), true);
	PrefSetAppPreferences(TGMB_APPTYPE, PREF_RMX_PORT, 1,&rmxPort_,
			      sizeof(rmxPort_), true);
	PrefSetAppPreferences(TGMB_APPTYPE, PREF_DONT_SUSPEND, 1,&dontSuspend_,
			      sizeof(dontSuspend_), true);
}


void
TGMB_Preferences::FromSystem()
{
	Word  prefSize;
	SWord gotSize;

	prefSize = sizeof(userName_);
	gotSize = PrefGetAppPreferences(TGMB_APPTYPE, PREF_USER_NAME,userName_,
					&prefSize, true);
	if (gotSize==noPreferenceFound) {
		TG_StrNCopy(userName_,TGMB_DEFAULT_UserName,sizeof(userName_));
	}

	prefSize = sizeof(rmxSvr_);
	gotSize = PrefGetAppPreferences(TGMB_APPTYPE, PREF_RMX_SVR,
					rmxSvr_, &prefSize, true);
	if (gotSize==noPreferenceFound) {
		TG_StrNCopy(rmxSvr_, TGMB_DEFAULT_RmxSvr, sizeof(rmxSvr_));
	}

	prefSize = sizeof(rmxPort_);
	gotSize = PrefGetAppPreferences(TGMB_APPTYPE, PREF_RMX_PORT,
					&rmxPort_, &prefSize, true);
	if (gotSize==noPreferenceFound) {
		rmxPort_ = TGMB_DEFAULT_RmxPort;
	}

	prefSize = sizeof(dontSuspend_);
	gotSize = PrefGetAppPreferences(TGMB_APPTYPE, PREF_DONT_SUSPEND,
					&dontSuspend_, &prefSize, true);
	if (gotSize==noPreferenceFound) {
		dontSuspend_ = TGMB_DEFAULT_DontSuspend;
	}
}


void
TGMB_Preferences::ToForm(FormPtr frm)
{
	FieldPtr fld;

	fld = (FieldPtr) TG_FrmGetObjectPtr(frm, PF_UserNameFld);
	TG_FldSetText(fld, userName_);

	fld = (FieldPtr) TG_FrmGetObjectPtr(frm, PF_RmxSvrFld);
	TG_FldSetText(fld, rmxSvr_);

	fld = (FieldPtr) TG_FrmGetObjectPtr(frm, PF_RmxPrtFld);
	TG_FldSetText(fld, rmxPort_);

	ControlPtr ctl;
	ctl = (ControlPtr) TG_FrmGetObjectPtr(frm, PF_DontSuspendBtn);
	CtlSetValue(ctl, dontSuspend_);
}


void
TGMB_Preferences::FromForm(FormPtr frm)
{
	FieldPtr fld;
	CharPtr  val;

	fld = (FieldPtr) TG_FrmGetObjectPtr(frm, PF_UserNameFld);
	val = FldGetTextPtr(fld);
	StrCopy(userName_, (val ? val:""));
	StrTrim(userName_);

	fld = (FieldPtr) TG_FrmGetObjectPtr(frm, PF_RmxSvrFld);
	val = FldGetTextPtr(fld);
	StrCopy(rmxSvr_, (val ? val:""));
	StrTrim(rmxSvr_);

	fld = (FieldPtr) TG_FrmGetObjectPtr(frm, PF_RmxPrtFld);
	val = FldGetTextPtr(fld);
	rmxPort_ = (val ? StrAToI(val) : 0);

	ControlPtr ctl;
	ctl = (ControlPtr) TG_FrmGetObjectPtr(frm, PF_DontSuspendBtn);
	dontSuspend_ = (CtlGetValue(ctl) ? 1 : 0);
}

