#!/usr/bin/perl
# script to generate OOo bash_completion file for the main applications
# written by Rene Engelhard <rene@debian.org>, Public Domain
# updated for ooo-build by Petr Mladek <pmladek@suse.cz>, Public Domain
# yes, this script probably is not real good code :) but still easier
# to maintain than adding those entries statically many times in
# a file...

@DRAWDOCS=("sxd", "std", "dxf", "emf", "eps", "met", "pct", "sgf", "sgv", "sda",
	   "sdd", "vor", "svm", "wmf", "bmp", "gif", "jpg", "jpeg", "jfif", "fif",
	   "jpe", "pcd", "pcx", "pgm", "png", "ppm", "psd", "ras", "tga", "tif",
	   "tiff", "xbm", "xpm");

@IMPRESSDOCS=("sxi", "sti", "ppt", "pps", "pot", "sxd", "sda", "sdd", "sdp",
	      "vor", "cgm");

@TEMPLATES=("stw", "dot", "vor", "stc", "xlt", "sti", "pot", "std", "stw");

@MATHDOCS=("sxm", "smf", "mml");

@MASTERDOCS=("sxg", "xgl", "txt");

@WRITERDOCS=("doc", "dot", "rtf", "sxw", "stw", "sdw", "vor", "txt", "htm?",
	     "xml", "wp", "wpd");

@WEBDOCS=("htm", "html", "stw", "txt", "vor");

@CALCDOCS=("sxc", "stc", "dif", "dbf", "xls", "xlw", "xlt", "rtf", "sdc", "vor",
	   "slk", "txt", "htm", "html", "wk1", "wks", "123", "xml");

@APPS=("openoffice", "oodraw", "ooimpress", "oofromtemplate", "oomath", "oomaster", "oowriter", "ooweb", "oocalc");

@CMDARGS=("-accept", "-display", "-invisible", "-minimized", "-norestore",
	  "-p", "-pt", "-quickstart", "-server", "-terminate_after_init");

if ( $ARGV[0] eq "") { die "You need to specify an output file!"; }

my $filename = shift;

open (BCFILE, "> $filename") || die "could not open target file!!";

print BCFILE "\# programmable bash_completion file for the main OpenOffice.org";
print BCFILE " applications\n\n";

foreach(@APPS) {
	print BCFILE "_" . $_ . "() {\n";
	print BCFILE "\tlocal prev options\n\n";
	print BCFILE "\tCOMPREPLY=()\n";
	print BCFILE "\tcur=\${COMP_WORDS[COMP_CWORD]}\n";
	print BCFILE "\tprev=\${COMP_WORDS[COMP_CWORD-1]}\n";
	print BCFILE "\toptions='";
	foreach(@CMDARGS) {
		print BCFILE $_;
		print BCFILE " ";
	}
	print BCFILE "'\n";
	print BCFILE "\tcase \$prev in\n";
	print BCFILE "\t\t*)\n";
	print BCFILE "\t\t\tCOMPREPLY=( \$(\n";
	if ($_ eq "oodraw" ) { $extensions="@DRAWDOCS"; }
	if ($_ eq "oowriter") { $extensions="@WRITERDOCS"; }
	if ($_ eq "ooweb") { $extensions="@WEBDOCS"; }
	if ($_ eq "oomath") { $extensions="@MATHDOCS"; }
	if ($_ eq "ooimpress") { $extensions="@IMPRESSDOCS"; }
	if ($_ eq "oocalc") { $extensions="@CALCDOCS"; }
	if ($_ eq "oomaster") { $extensions="@MASTERDOCS"; }
	if ($_ eq "oofromtemplate") { $extensions="@TEMPLATES"; }
	# openoffice should contain all...
	if ($_ eq "openoffice") {
		$extensions="@DRAWDOCS @WRITERDOCS @MATHDOCS @IMPRESSDOCS";
		$extensions="$extensions @CALCDOCS @MASTERDOCS @TEMPLATES";
		$extensions="$extensions @WEBDOCS";
	}
	foreach (split(/ /,$extensions)) {
		print BCFILE "\t\t\t\tcompgen -G \"\${cur}*\" -X \'!*.$_\'\n";
	}
	print BCFILE "\t\t\t\tcompgen -W \"\$options\" | grep \"^\$cur\"\n";
	print BCFILE "\t\t\t) )\n";
	print BCFILE "\t\t;;\n";
	print BCFILE "\tesac\n\n";
	print BCFILE "\treturn 0\n\n";
	print BCFILE "}\n";
	print BCFILE "complete -d -X \'.[^./]*\' -F _$_ -o filenames $_\n\n";
}

close(BCFILE)

