# Copyright (C) 2000-2001 The OpenRPG Project
#
#    openrpg-dev@lists.sourceforge.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# --
#
# File: mapper/images.py
# Author: OpenRPG
# Maintainer:
# Version:
#   $Id: images.py,v 1.10 2003/09/26 04:47:10 tdb30_ Exp $
#
# Description:
#
__version__ = "$Id: images.py,v 1.10 2003/09/26 04:47:10 tdb30_ Exp $"

import urllib
import Queue
import thread
import string
from threading import Lock

from orpg.orpg_windows import *
#import gdic  
import orpg.dirpath
import time

## Image cache globals
# Default image cache size -- may be over-ridden
IMAGE_CACHE_SIZE = 64
imageCache = {}
imageQueue = Queue.Queue(0)
imageFetchList = {}
imageFetchLock = Lock()


def load_img( path, object_type, image_object ):
    """This funciton loads an image from a URL and returns a wxBitmap"""

    # If we already have it cached, simply return the image to the caller
    if imageCache.has_key(path):
        return imageCache[path]

    pos = string.rfind(path,'.')
    ext = string.lower(path[pos+1:])
    image_type = 0
    if ext == "gif":
        image_type = wxBITMAP_TYPE_GIF
    elif (ext == "jpg") | (ext == "jpeg"):
        image_type = wxBITMAP_TYPE_JPEG
    elif ext == "bmp":
        image_type = wxBITMAP_TYPE_BMP
    elif ext == "png":
        image_type = wxBITMAP_TYPE_PNG
    else:
        return None
        raise Exception, "Not a valid image type!"

    # Now, keep track of which URI we are fetching to optimize
    # the applications of the fetched images
    imageFetchLock.acquire()
    if imageFetchList.has_key( path ):
        imageListList = imageFetchList[path]
        imageListList.append( (path, image_type, object_type, image_object) )

    else:
        imageFetchList[path] = [ (path, image_type, object_type, image_object) ]

        # Now, start up a thread to asynchronously fetch our resource via it's URI
        thread.start_new_thread( thread_get_data,(path, image_type, object_type, image_object) )
    imageFetchLock.release()

    img = wxBitmap(orpg.dirpath.dir_struct["icon"]+"fetching.png",wxBITMAP_TYPE_PNG)
    return img

# don't use this!
#def delete_img(bmp):
    #pass
    #gdic.delete_wxBitmap(bmp)

def thread_get_data( path, image_type, object_type, image_object ):
    """Thread which fetches the url passed in as path."""

    # Make sure the path is valid and generally safe to reference sa an URI

    # Don't quote colons and slashes

    uriPath = urllib.quote(path, ":/")

    try:
        time.sleep(.1)
        d = urllib.urlretrieve( uriPath )
        data = d[0]
        # We have to make sure that not only did we fetch something, but that

        # it was an image that we got back.

        if data and d[1].getmaintype() == "image":
            imageFetchLock.acquire()
            if imageFetchList.has_key( path ):
                imageListList = imageFetchList[path]
            else:
                imageListList = []
            cntTo = len(imageListList)
            imageFetchLock.release()

            cnt = 0

            while cnt < cntTo:
                (path, image_type, object_type, image_object) = imageListList[cnt]
                imageQueue.put( (path, data, image_type, object_type, image_object) )
                cnt += 1
                imageFetchLock.acquire()
                if imageFetchList.has_key( path ):
                    del imageFetchList[path]
                imageFetchLock.release()
        else:
            print "Image refused to load or URI did not reference a valid image:" + path

    except IOError, e:
        print "Cleaning fetch list..."
        imageFetchLock.acquire()
        if imageFetchList.has_key( path ):
            del imageFetchList[path]
        imageFetchLock.release()
        print "Unable to resolve/open the specified URI; image was NOT laoded:" + path
        pass


def flushImageCache():
    """This function will flush all images contained within the image cache.
Plese not that this function must be called from the primary thread as it is not thread safe.  As such, it assumes that nothing else is working on the list at the same time this function is working"""

    keyList = imageCache.keys()
    for key in keyList:
        del imageCache[key]
